/* $Id: MCQ.js 2931 2009-01-05 15:41:18Z davemckain $
 *
 * Copyright (c) 2003 - 2009 University of Edinburgh.
 * All Rights Reserved.
 */

//------------------------------------------------------------

/* This contains JS for managing the interaction of MCQ Self Tests */

//------------------------------------------------------------

var isSetUp = false; // Flag to indicate that form DOM elements have been found
var checkButton = null; // Form submission button
var clearButton = null; // "Clear Form" button
var containerDivs = null; // Array of answer/feedback containers
var answerInputs = null; // Form controls for submitting answers
var feedbackDivs = null; // Array of feedback divs
var answerCount  = 0; // Number of answers
var correctCount = 0; // Number of required choices === #correct answers

/* This initialises state by searching for relevant DOM elements in
 * the XHTML page.
 */
function _setUp() {
  if (document.getElementById) {
    /* Look up "Check Answer" button */
    checkButton = document.getElementById("check");
    clearButton = document.getElementById("clear");
    /* Then find each answer/feedback answer + content */
    containerDivs = new Array();
    answerInputs = new Array();
    feedbackDivs = new Array();
    answerCount = 0;
    var finished = false;
    for (var i=0; !finished; i++) {
      var containerDiv = document.getElementById("container" + i);
      var answerInput = document.getElementById("answer" + i);
      var feedbackDiv = document.getElementById("feedback" + i);
      if (containerDiv!=null && answerInput!=null && feedbackDiv!=null) {
        containerDivs[i] = containerDiv;
        answerInputs[i] = answerInput;
        feedbackDivs[i] = feedbackDiv;
        answerCount++;
        if (feedbackDiv.className=="feedbackContainerCorrect") {
          correctCount++;
        }
      }
      else {
        /* Ran out of DOM elements */
        finished = true;
      }
    }
  }
}

/* Checks whether _setUp() has been called, calling it if not and
 * doing nothing otherwise.
 */
function _ensureSetUp() {
  if (!isSetUp) {
    _setUp();
    isSetUp = true;
  }
}

//------------------------------------------------------------

/* Updates CSS classes of each feedback box to reflect selection state */
function updateSelection() {
  _ensureSetUp();
  var container, input, i;
  for (i=0; i<answerCount; i++) {
    container = containerDivs[i];
    input = answerInputs[i];
    container.className = "answerContainer"
      + (input.checked ? "S" : "Uns" ) + "elected";
  }
  /* Then update the state of the buttons */
  updateButtonState();
}

/* Shows feedback for each selected item */
function showFeedback() {
  _ensureSetUp();
  /* First, hide any existing feedback */
  clearFeedback();
  /* Then display feedback for each selected item */
  for (var i=0; i<answerCount; i++) {
    if (answerInputs[i].checked) {
      feedbackDivs[i].style.display = "block";
    }
  }
  return false;
}

/* Clears all displayed feedback */
function clearFeedback() {
  _ensureSetUp();
  for (var i=0; i<answerCount; i++) {
    feedbackDivs[i].style.display = "none";
  }
}

/* Updates visibility of the "Check Answer" so that it is enabled
 * if the exact number of requied choices is selected, disabled otherwise.
 */
function updateButtonState() {
  _ensureSetUp();
  /* Find out how many answers are selected */
  var selectedCount = 0;
  for (var i=0; i<answerCount; i++) {
    if (answerInputs[i].checked) {
      selectedCount++;
    }
  }
  checkButton.disabled = (selectedCount!=correctCount);
  clearButton.disabled = (selectedCount==0);
}

function clearAll() {
  _ensureSetUp();
  for (var i=0; i<answerCount; i++) {
    answerInputs[i].checked = false;
  }
  clearFeedback();
  updateSelection();
  updateButtonState();
}
