/* $Id: Core.js 2931 2009-01-05 15:41:18Z davemckain $
 *
 * Copyright (c) 2003 - 2009 University of Edinburgh.
 * All Rights Reserved.
 */

//------------------------------------------------------------

/* This file defines some of the common Classes and settings
 * used across many Aardvark web Resource outputs.
 *
 * Prerequisites: Logger.js, Utilities.js
 */

//------------------------------------------------------------

/* Normal log level settings */
Logger.setLogLevel("*", LogLevel.ERROR);

//------------------------------------------------------------

/* Functionality for managing hide/reveal panes within pages. */
function ContentController() {}

ContentController.prototype = {

    setVisibility: function(/*String*/ id, /*Boolean*/ isVisible) {
        var container = document.getElementById(id);
        if (container!=null) {
            this._setVisibility(container, isVisible);
        }
        return false;
    },

    /* Updates the visibillity of all callout elements within the current
      * page. These are defined to be all <div class="callout">...</div>
      * elements.
      */
    setGlobalVisibility: function(/*Boolean*/ isVisible) {
        var allDivs = document.getElementsByTagName("div");
        for (var i=0; i<allDivs.length; i++) {
            var div = allDivs[i];
            if (div.className=="callout") {
                this._setVisibility(div, isVisible);
            }
        }
        return false;
    },

    /* Private function to do the actual visibility modifications */
    _setVisibility: function(divElement, isVisible) {
        /* Look at immediate children to determine what to display/hide */
        var children = divElement.childNodes;
        if (children!=null) {
            for (var i=0; i<children.length; i++) {
                var element = children[i];
                var className = element.className;
                if (className!=null) {
                    if (className=="minimised") {
                        element.style.display = (isVisible) ? "none" : "block";
                    }
                    else if (className=="maximised") {
                        element.style.display = (isVisible) ? "block" : "none";
                    }
                }
            }
        }
    }
}

ContentController._singleton = new ContentController();

window.getContentController = function() {
    return ContentController._singleton;
}
