<?xml version="1.0"?>
<!--

This is a simplified version of David Carlisle's "Universal Style Sheet"
for presentational MathML, available from http://www.w3.org/Math/XSL/pmathml.xsl

This simpification assumes the following restrictions:

1. Client is using Mozilla/Firefox or IE6/7 with MathPlayer installed.
2. No pref:renderer support exists.
3. MathPlayer annotations are not supported.

Exports from Aardvark will now use a landing page to determine that the
client is using a supported browser, which cuts down the amount of
checking required.

Copyright (c) 2003 - 2009 University of Edinburgh

This contains parts of pamthml.xsl; Copyright (c) David Carlisle 2001, 2002.

$Id: pmathml-minimal.xsl 2931 2009-01-05 15:41:18Z davemckain $

-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:m="http://www.w3.org/1998/Math/MathML"
  xmlns:h="http://www.w3.org/1999/xhtml"
  xmlns="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="h">

  <xsl:output method="xml" omit-xml-declaration="yes"/>

  <!-- We make a top level branch decision based on whether client is using Mozilla
       or IE. The former is a trivial identity transform; the latter requires more
       work.
    -->
  <xsl:template match="h:html">
    <xsl:choose>
      <xsl:when test="system-property('xsl:vendor')='Microsoft'">
        <!-- We're on IE, presumably with MathPlayer installed so need to do careful
        transform of the content -->
        <html>
          <xsl:apply-templates mode="ie"/>
        </html>
      </xsl:when>
      <xsl:otherwise>
        <!-- Copy original document verbatim -->
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- ************************************************************ -->
  <!-- Templates for IE                                             -->
  <!-- ************************************************************ -->

  <xsl:template match="h:head" mode="ie">
    <head>
      <object id="MathPlayer" classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987">
        <xsl:text> </xsl:text>
      </object>
      <xsl:processing-instruction name="import"> namespace="m" implementation="#MathPlayer"</xsl:processing-instruction>
      <xsl:apply-templates mode="ie"/>
    </head>
  </xsl:template>

  <h:p>The main bulk of this stylesheet is an identity transformation so...</h:p>
  <xsl:template match="*|comment()" mode="ie">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates mode="ie"/>
    </xsl:copy>
  </xsl:template>

  <h:p>XHTML elements are copied sans prefix (XHTML is default namespace
  here, so these elements will still be in XHTML namespace</h:p>
  <xsl:template match="h:*" mode="ie">
    <xsl:element name="{local-name(.)}">
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates mode="ie"/>
    </xsl:element>
  </xsl:template>

  <h:p>IE's treatment of XHTML as HTML needs a little help here...</h:p>
  <xsl:template match="h:br|h:hr" mode="ie">
    <xsl:value-of disable-output-escaping="yes" select="concat('&lt;',local-name(.))"/>
    <xsl:apply-templates mode="verb" select="@*"/>
    <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>

  <h:p>Somewhat bizarrely in an otherwise namespace aware system,
  Microsoft behaviours are defined to trigger off the
  <h:em>prefix</h:em> not the <h:em>Namespace</h:em>. In the code above
  we associated a MathML rendering behaviour (if one was found) with the
  prefix <h:code>m:</h:code> so here we ensure that this is the prefix
  that actually gets used in the output.</h:p>
  <xsl:template match="m:*" mode="ie">
    <xsl:element name="m:{local-name(.)}">
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates mode="ie"/>
    </xsl:element>
  </xsl:template>

  <!-- ************************************************************ -->
  <!-- Helpers (from original pmathml.xsl)                          -->
  <!-- ************************************************************ -->
  <!-- The following templates are used to copy elements "verbatim" -->

  <!-- non empty elements and other nodes. -->
  <xsl:template mode="verb" match="*[*]|*[text()]|*[comment()]|*[processing-instruction()]">
    <xsl:value-of select="concat('&lt;',local-name(.))"/>
    <xsl:apply-templates mode="verb" select="@*"/>
    <xsl:text>&gt;</xsl:text>
    <xsl:apply-templates mode="verb"/>
    <xsl:value-of select="concat('&lt;/',local-name(.),'&gt;')"/>
  </xsl:template>

  <!-- empty elements -->
  <xsl:template mode="verb" match="*">
    <xsl:value-of select="concat('&lt;',local-name(.))"/>
    <xsl:apply-templates mode="verb" select="@*"/>
    <xsl:text>/&gt;</xsl:text>
  </xsl:template>

  <!-- attributes
       Output always surrounds attribute value by "
       so we need to make sure no literal " appear in the value  -->
  <xsl:template mode="verb" match="@*">
    <xsl:value-of select="concat(' ',local-name(.),'=')"/>
    <xsl:text>"</xsl:text>
    <xsl:call-template name="string-replace">
      <xsl:with-param name="from" select="'&quot;'"/>
      <xsl:with-param name="to" select="'&amp;quot;'"/> 
      <xsl:with-param name="string" select="."/>
    </xsl:call-template>
    <xsl:text>"</xsl:text>
  </xsl:template>

  <!-- pis -->
  <xsl:template mode="verb" match="processing-instruction()"/>

  <!-- only works if parser passes on comment nodes -->
  <xsl:template mode="verb" match="comment()"/>

  <!-- text elements
       need to replace & and < by entity references-->
  <xsl:template mode="verb" match="text()">
    <a name="{generate-id(.)}"/>
    <xsl:call-template name="string-replace">
      <xsl:with-param name="to" select="'&amp;gt;'"/>
      <xsl:with-param name="from" select="'&gt;'"/> 
      <xsl:with-param name="string">
        <xsl:call-template name="string-replace">
          <xsl:with-param name="to" select="'&amp;lt;'"/>
          <xsl:with-param name="from" select="'&lt;'"/> 
          <xsl:with-param name="string">
            <xsl:call-template name="string-replace">
              <xsl:with-param name="to" select="'&amp;amp;'"/>
              <xsl:with-param name="from" select="'&amp;'"/> 
              <xsl:with-param name="string" select="."/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <!-- replace all occurences of the character(s) `from'
       by the string `to' in the string `string'.-->
  <xsl:template name="string-replace" >
    <xsl:param name="string"/>
    <xsl:param name="from"/>
    <xsl:param name="to"/>
    <xsl:choose>
      <xsl:when test="contains($string,$from)">
        <xsl:value-of select="substring-before($string,$from)"/>
        <xsl:value-of select="$to"/>
        <xsl:call-template name="string-replace">
          <xsl:with-param name="string" select="substring-after($string,$from)"/>
          <xsl:with-param name="from" select="$from"/>
          <xsl:with-param name="to" select="$to"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
