/* $Id: DeploymentIndex.js 2931 2009-01-05 15:41:18Z davemckain $
 *
 * Copyright (c) 2003 - 2009 University of Edinburgh.
 * All Rights Reserved.
 */

//------------------------------------------------------------

/* This JavaScript controls the top page of a Deployment. I've
 * not bothered to make this Object-oriented since it's so simple.
 *
 * Prerequisites: None!
 */
function $(id) {
  return document.getElementById(id);
}

function updateDisplay() {
  var form = document.forms[0];
  var navSelector = form.navSelector;
  var navSelection = form.navSelector.value;

  if (navSelection=='deploymentframeset') {
    setDisplayStyle("startSelectorContainer", 'list-item');
    setDisplayStyle("hidebreadcrumbsContainer", 'list-item');
    setDisplayStyle("aboutNav0", 'block');
    setDisplayStyle("aboutNav1", 'none');
    setDisplayStyle("aboutNav2", 'none');
  }
  else if (navSelection=='deploymentframesetindex') {
    setDisplayStyle("startSelectorContainer", 'none');
    setDisplayStyle("hidebreadcrumbsContainer", 'list-item');
    setDisplayStyle("aboutNav0", 'none');
    setDisplayStyle("aboutNav1", 'block');
    setDisplayStyle("aboutNav2", 'none');
  }
  else if (navSelection=='deploymentframeless') {
    setDisplayStyle("startSelectorContainer", 'none');
    setDisplayStyle("hidebreadcrumbsContainer", 'none');
    setDisplayStyle("aboutNav0", 'none');
    setDisplayStyle("aboutNav1", 'none');
    setDisplayStyle("aboutNav2", 'block');
  }

  /* Make target URL */
  var url = makeResourceNameAndExtension(navSelection, 'html',
    form.hidebreadcrumbs && form.hidebreadcrumbs.value==1 && navSelection!='deploymentframeless',
    form.compatmode && form.compatmode.value==1,
    form.nopng && form.nopng.value==1);
  if (navSelection=='deploymentframeset') {
    url += '#tree=' + form.startSelector.value;
  }
  $("target").href = url;

  /* Now relativise the target URL against the URL of the deployment index page, which
   * is passed in the HTML as a hidden link with ID 'indexLink' */
  var indexUrl = document.getElementById("indexLink").href;
  var displayUrl = indexUrl.replace(/deploymentindex\.html$/, url);
  $("target").href = displayUrl;
  $("target").childNodes[0].nodeValue = displayUrl;
}


/* Takes a varargs array of keys and values afterwards */
function makeResourceNameAndExtension(baseName, fileExtension, hideBreadcrumbs, compatMode, noPNG) {
  /* NB: Need to be careful to keep keys in natural order when constructing URLs below */
  var result = baseName;
  if (compatMode) {
    result += '-compatmode';
  }
  if (hideBreadcrumbs) {
    result += '-hidebreadcrumbs';
  }
  if (noPNG) {
    result += '-nopng';
  }
  result += '.' + fileExtension;
  return result;
}

function setDisplayStyle(id, style) {
  $(id).style.display = style;
}

/* Force display update after load */
onload = updateDisplay;
