/* $Id: BrowserChecker.js 2931 2009-01-05 15:41:18Z davemckain $
 *
 * Copyright (c) 2003 - 2009 University of Edinburgh.
 * All Rights Reserved.
 */

//------------------------------------------------------------

/* This class contains the required JavaScript for managing
 * browser checks and landing pages to ensure that clients
 * have suitably equipped browsers for handling MathML, allowing
 * an optional fallback to compatibility mode for users if they
 * really want.
 *
 * Prerequisites: Utilities.js
 */

//------------------------------------------------------------

function BrowserChecker() {}

/* Browser capability testing */

BrowserChecker.isMathPlayerInstalled = function() {
    try {
        new ActiveXObject("MathPlayer.Factory.1");
        return true;
    }
    catch(e) {
        return false;
    }
}

BrowserChecker.isIEWindows = function() {
    return navigator.appName=="Microsoft Internet Explorer"
      && navigator.appVersion.indexOf("Windows")!=-1;
}

BrowserChecker.getIEWindowsVersion = function() {
    var result = -1;
    if (BrowserChecker.isIEWindows()) {
        var appVersion = navigator.appVersion;
        var search = "MSIE ";
        var start = appVersion.indexOf(search);
        if (start!=-1) {
            result = parseFloat(appVersion.substring(start + search.length));
        }
    }
    return result;
}

BrowserChecker.isMathMLEnabledMozilla = function() {
    var userAgent = navigator.userAgent;
    var isGecko = userAgent.indexOf("Gecko/")!=-1;

    /* More checking here for obscure Gecko browsers which don't support MathML!?? */

    return isGecko; /* ... leap of faith! */
}

BrowserChecker.isBrowserCapable = function() {
    return BrowserChecker.isMathMLEnabledMozilla() ||
        (BrowserChecker.getIEWindowsVersion()>=6.0 && BrowserChecker.isMathPlayerInstalled());
}

//------------------------------------------------------------

BrowserChecker.cookieMatch = "aardvarkCompatMode=";

/* Cookie values:
 *
 * 0: not running compat mode in this session; bring up warning on entry.
 * 1: running compat mode in this session; automatically go to compat fallback on entry.
 */

BrowserChecker.getCompatModeCookieValue = function() {
    var cookieValue = document.cookie;
    var matchPosition = -1;
    var result = false;
    if (cookieValue!=null) {
        matchPosition = cookieValue.indexOf(BrowserChecker.cookieMatch);
    }
    if (matchPosition>=0) {
        result = cookieValue.substr(matchPosition + BrowserChecker.cookieMatch.length, 1)=='1';
    }
    return result;
}

BrowserChecker.setCompatModeCookieValue = function(isVisitedBrowserTuneupPage) {
    document.cookie = BrowserChecker.cookieMatch + (isVisitedBrowserTuneupPage?'1':'0')
        + "; path=/";
}

BrowserChecker.makeCompatModeUrl = function(originalUrl) {
    /* Create fallback URL by adding '-compatmode' key to original caller URL. */
    return Utilities.addRenderingSpecs(originalUrl, 'compatmode');
}

//------------------------------------------------------------

function BrowserTuneupPage() {}

BrowserTuneupPage.setup = function() {
    /* We shouldn't normally get here if the browser is already capable but let's
     * handle it anyway */
    if (BrowserChecker.isBrowserCapable()) {
        document.getElementById("browserOK").style.display = 'block';
        document.getElementById("browserWarning").style.display = 'none';
        BrowserTuneupPage.proceed();
        return;
    }
    else {
        /* Show appropriate options */
        if (BrowserChecker.isIEWindows()) {
            document.getElementById("ieOptions").style.display = 'block';
        }
        else {
            document.getElementById("otherOptions").style.display = 'block';
        }
    }
}

BrowserTuneupPage.getTuneupCallerUrl = function() {
    /* Recover URL of referring page by decoding search query */
    return unescape(location.search.substr(1));
}

BrowserTuneupPage.getTuneupFallbackUrl = function() {
    var originalUrl = BrowserTuneupPage.getTuneupCallerUrl();
    return BrowserChecker.makeCompatModeUrl(originalUrl);
}

BrowserTuneupPage.proceedIfMathPlayerInstalled = function() {
    if (BrowserChecker.isMathPlayerInstalled()) {
        return BrowserTuneupPage.proceed();
    }
    alert("MathPlayer has not been detected - please check that you really have installed it!");
    return false;
}

BrowserTuneupPage.proceedInCompatibilityMode = function() {
    /* Set cookie to indicate we're running in compat mode in this session */
    BrowserChecker.setCompatModeCookieValue(true);

    /* Get URL to fall back to and redirect */
    var fallbackUrl = BrowserTuneupPage.getTuneupFallbackUrl();
    if (fallbackUrl.length > 0) {
        location.replace(fallbackUrl);
        return false;
    }
    else {
        /* (This can occur if the client loads the tuneup page directly, so bail out to avoid looping) */
        return true;
    }
}

BrowserTuneupPage.proceed = function() {
    var targetUrl = BrowserTuneupPage.getTuneupCallerUrl();
    if (targetUrl.length > 0) {
        location.replace(targetUrl);
        return false;
    }
    else {
        /* (This can occur if the client loads the tuneup page directly, so bail out to avoid looping) */
        return true;
    }
}

//------------------------------------------------------------

function LandingPage() {}

LandingPage.redirectIfRequired = function() {
    var isBrowserCapable = BrowserChecker.isBrowserCapable();
    var isCompatMode = BrowserChecker.getCompatModeCookieValue();
    if (!isBrowserCapable) {
        if (isCompatMode) {
            /* Automatically redirect to the compatibility version of this page. */
            var compatModeUrl = BrowserChecker.makeCompatModeUrl(location.href);
            location.replace(compatModeUrl);
        }
        else {
            /* We'll send user to the tuneup page to let them decide what to do. */
            /* Get URL of Tune-Up page from Link Attributes */
            var linkElement = document.getElementById("browserTuneup");
            var tuneupUrl = linkElement.getAttribute("href");

            /* Redirect to tuneup page, passing the URL of this entry page so that we
             * can redirect back (or to compatibility version) appropriately.
             */
            var escapedLocation = escape(location.href);
            var redirectUrl = tuneupUrl + "?" + escapedLocation;
            location.replace(redirectUrl);
        }
    }
}
