(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5844,        222]
NotebookOptionsPosition[      4978,        186]
NotebookOutlinePosition[      5315,        201]
CellTagsIndexPosition[      5272,        198]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 FormBox[
  RowBox[{"f", "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"HermiteH", "[", 
        RowBox[{"20", ",", "y"}], "]"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["y", "2"]}], "/", "2"}]]}], ")"}], "2"], "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["2", "20"], " ", 
      RowBox[{"20", "!"}], " ", 
      RowBox[{"Sqrt", "[", "\[Pi]", "]"}]}], ")"}]}]}], 
  TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       SuperscriptBox["y", "2"]}]], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1048576", " ", 
         SuperscriptBox["y", "20"]}], "-", 
        RowBox[{"99614720", " ", 
         SuperscriptBox["y", "18"]}], "+", 
        RowBox[{"3810263040", " ", 
         SuperscriptBox["y", "16"]}], "-", 
        RowBox[{"76205260800", " ", 
         SuperscriptBox["y", "14"]}], "+", 
        RowBox[{"866834841600", " ", 
         SuperscriptBox["y", "12"]}], "-", 
        RowBox[{"5721109954560", " ", 
         SuperscriptBox["y", "10"]}], "+", 
        RowBox[{"21454162329600", " ", 
         SuperscriptBox["y", "8"]}], "-", 
        RowBox[{"42908324659200", " ", 
         SuperscriptBox["y", "6"]}], "+", 
        RowBox[{"40226554368000", " ", 
         SuperscriptBox["y", "4"]}], "-", 
        RowBox[{"13408851456000", " ", 
         SuperscriptBox["y", "2"]}], "+", "670442572800"}], ")"}], "^", 
      "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"2551082656125828464640000", " ", 
     SqrtBox["\[Pi]"]}], ")"}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Sqrt", "[", "21.", "]"}], TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox["4.58257569495583982`", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"An", " ", "=", " ", 
   SqrtBox[
    RowBox[{"41", "/", "2."}]]}], TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox["4.52769256906870776`", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"strm", "=", 
    RowBox[{"OpenWrite", "[", "\"\<H10\>\"", "]"}]}], ";", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"k", "=", 
      RowBox[{"-", "5."}]}], ",", 
     RowBox[{"k", "<=", "5"}], ",", 
     RowBox[{"k", "+=", "0.02"}], ",", 
     RowBox[{"Write", "[", 
      RowBox[{"strm", ",", "k", ",", "\"\<  \>\"", ",", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["f", "2"], "/", 
           RowBox[{"(", 
            RowBox[{"3715891200", " ", 
             SqrtBox["\[Pi]"]}], ")"}]}], ")"}], "/.", 
         RowBox[{"y", "\[Rule]", "k"}]}], ")"}]}], "]"}]}], "]"}], ";", 
   RowBox[{"Close", "[", "strm", "]"}]}], TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox["\<\"H10\"\>", TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["x", "2"]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "a"}], ",", "a"}], "}"}]}], "]"}], 
  TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"a", ">", "0"}], ",", "\[Pi]", ",", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "a"}], "a"], 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["x", "2"]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "]"}], 
  TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"a", "\[Rule]", "An"}]}], "}"}]}], TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox["0.0982325635284222009`", TraditionalForm]], "Output"]
}, Open  ]]
},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 150}, {0, Automatic}},
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 535, 18, 40, "Input"],
Cell[1105, 42, 1214, 34, 158, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2356, 81, 88, 2, 32, "Input"],
Cell[2447, 85, 75, 1, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2559, 91, 129, 4, 42, "Input"],
Cell[2691, 97, 75, 1, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2803, 103, 764, 22, 114, "Input"],
Cell[3570, 127, 66, 1, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3673, 133, 345, 12, 32, "Input"],
Cell[4021, 147, 429, 15, 52, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4487, 167, 395, 13, 32, "Input"],
Cell[4885, 182, 77, 1, 32, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

