(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    114318,       2435]
NotebookOptionsPosition[    110831,       2307]
NotebookOutlinePosition[    111502,       2331]
CellTagsIndexPosition[    111459,       2328]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["k =.", "Input",
 AspectRatioFixed->True],

Cell["phi1[x_]:= A1 Exp[I k x]+B1 Exp[-I k x]", "Input",
 AspectRatioFixed->True],

Cell["phi2[x_] := A2 Cosh[kappa x] + B2 Sinh[kappa x]", "Input",
 AspectRatioFixed->True],

Cell["phi3[x_] := A3 Exp[I k x]", "Input",
 AspectRatioFixed->True],

Cell["\<\
eqns1 = phi1[-a]==phi2[-a];eqns2=phi2[a]==phi3[a];
eqns3 = phi1'[-a]==phi2'[-a]; eqns4 = phi2'[a]==phi3'[a];
eqns={eqns1,eqns2,eqns3,eqns4};\
\>", "Input",
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["expr=Simplify[Solve[eqns,{A3,B1,A2,B2}]]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"A3", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
        "2", " ", "\[ImaginaryI]", " ", "A1", " ", "k", " ", "kappa", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]]}], 
        ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["k", "2"], "-", 
            SuperscriptBox["kappa", "2"]}], ")"}], " ", 
          RowBox[{"sinh", "(", 
           RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
          RowBox[{"cosh", "(", 
           RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"B1", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A1", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]], 
         " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "+", 
           SuperscriptBox["kappa", "2"]}], ")"}], " ", 
         RowBox[{"sinh", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["k", "2"], "-", 
            SuperscriptBox["kappa", "2"]}], ")"}], " ", 
          RowBox[{"sinh", "(", 
           RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
          RowBox[{"cosh", "(", 
           RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"A2", "\[Rule]", 
      FractionBox[
       RowBox[{"A1", " ", "k", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
       RowBox[{
        RowBox[{"k", " ", 
         RowBox[{"cosh", "(", 
          RowBox[{"a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kappa", " ", 
         RowBox[{"sinh", "(", 
          RowBox[{"a", " ", "kappa"}], ")"}]}]}]]}], ",", 
     RowBox[{"B2", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"A1", " ", "k", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
        RowBox[{
         RowBox[{"k", " ", 
          RowBox[{"sinh", "(", 
           RowBox[{"a", " ", "kappa"}], ")"}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "kappa", " ", 
          RowBox[{"cosh", "(", 
           RowBox[{"a", " ", "kappa"}], ")"}]}]}]]}]}]}], "}"}], "}"}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989356899919*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["expr = Flatten[expr]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A3", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
       "2", " ", "\[ImaginaryI]", " ", "A1", " ", "k", " ", "kappa", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "-", 
           SuperscriptBox["kappa", "2"]}], ")"}], " ", 
         RowBox[{"sinh", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
         RowBox[{"cosh", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}]}], ",", 
    RowBox[{"B1", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A1", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["k", "2"], "+", 
          SuperscriptBox["kappa", "2"]}], ")"}], " ", 
        RowBox[{"sinh", "(", 
         RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "-", 
           SuperscriptBox["kappa", "2"]}], ")"}], " ", 
         RowBox[{"sinh", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
         RowBox[{"cosh", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}]}], ",", 
    RowBox[{"A2", "\[Rule]", 
     FractionBox[
      RowBox[{"A1", " ", "k", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
      RowBox[{
       RowBox[{"k", " ", 
        RowBox[{"cosh", "(", 
         RowBox[{"a", " ", "kappa"}], ")"}]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", "kappa", " ", 
        RowBox[{"sinh", "(", 
         RowBox[{"a", " ", "kappa"}], ")"}]}]}]]}], ",", 
    RowBox[{"B2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"A1", " ", "k", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
       RowBox[{
        RowBox[{"k", " ", 
         RowBox[{"sinh", "(", 
          RowBox[{"a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kappa", " ", 
         RowBox[{"cosh", "(", 
          RowBox[{"a", " ", "kappa"}], ")"}]}]}]]}]}]}], "}"}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989357102027*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["sqT = A3/A1 /. expr", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]]}], 
    ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["k", "2"], "-", 
        SuperscriptBox["kappa", "2"]}], ")"}], " ", 
      RowBox[{"sinh", "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
      RowBox[{"cosh", "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893573034573`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trans=Simplify[ComplexExpand[sqT Conjugate[sqT]]]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SuperscriptBox["k", "2"], " ", 
     SuperscriptBox["kappa", "2"]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["k", "2"], "-", 
         SuperscriptBox["kappa", "2"]}], ")"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["sinh", "2"], "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["k", "2"], " ", 
      SuperscriptBox["kappa", "2"], " ", 
      RowBox[{
       SuperscriptBox["cosh", "2"], "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989357812367*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["sqR = B1/A1 /. expr", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["k", "2"], "+", 
       SuperscriptBox["kappa", "2"]}], ")"}], " ", 
     RowBox[{"sinh", "(", 
      RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["k", "2"], "-", 
        SuperscriptBox["kappa", "2"]}], ")"}], " ", 
      RowBox[{"sinh", "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
      RowBox[{"cosh", "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989357933165*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplify[ComplexExpand[sqR Conjugate[sqR]]]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{"-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["k", "2"], "+", 
         SuperscriptBox["kappa", "2"]}], ")"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["sinh", "2"], "(", 
       RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "+", 
           SuperscriptBox["kappa", "2"]}], ")"}], "2"], " ", 
        RowBox[{"cosh", "(", 
         RowBox[{"4", " ", "a", " ", "kappa"}], ")"}]}]}], "+", 
      SuperscriptBox["k", "4"], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["k", "2"], " ", 
       SuperscriptBox["kappa", "2"]}], "+", 
      SuperscriptBox["kappa", "4"]}], ")"}]}]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893582770643`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpl = Trans /. (kappa -> 1/a Sqrt[1-k^2 a^2])", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SuperscriptBox["k", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "-", 
           FractionBox[
            RowBox[{"1", "-", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["k", "2"]}]}], 
            SuperscriptBox["a", "2"]]}], ")"}], "2"], " ", 
        RowBox[{
         SuperscriptBox["sinh", "2"], "(", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["k", "2"]}]}]]}], ")"}]}], "+", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["k", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["k", "2"]}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["cosh", "2"], "(", 
          RowBox[{"2", " ", 
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["k", "2"]}]}]]}], ")"}]}], 
        SuperscriptBox["a", "2"]]}], ")"}]}], ")"}]}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893583827543`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell["phi2p[x_] := A2 Cos[ kappa x] + B2 Sin[kappa x]", "Input",
 AspectRatioFixed->True],

Cell["\<\
eqns1p = phi1[-a]==phi2p[-a];eqns2p=phi2p[a]==phi3[a];
eqns3p = phi1'[-a]==phi2p'[-a]; eqns4p = phi2p'[a]==phi3'[a];
eqnsp={eqns1p,eqns2p,eqns3p,eqns4p};\
\>", "Input",
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["exprp=Flatten[Simplify[Solve[eqnsp,{A3,B1,A2,B2}]]]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A3", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
       "2", " ", "\[ImaginaryI]", " ", "A1", " ", "k", " ", "kappa", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "+", 
           SuperscriptBox["kappa", "2"]}], ")"}], " ", 
         RowBox[{"sin", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}]}], ",", 
    RowBox[{"B1", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A1", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["k", "2"], "-", 
          SuperscriptBox["kappa", "2"]}], ")"}], " ", 
        RowBox[{"sin", "(", 
         RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "+", 
           SuperscriptBox["kappa", "2"]}], ")"}], " ", 
         RowBox[{"sin", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}], ")"}]}]}], ",", 
    RowBox[{"A2", "\[Rule]", 
     FractionBox[
      RowBox[{"A1", " ", "k", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
      RowBox[{
       RowBox[{"k", " ", 
        RowBox[{"cos", "(", 
         RowBox[{"a", " ", "kappa"}], ")"}]}], "-", 
       RowBox[{"\[ImaginaryI]", " ", "kappa", " ", 
        RowBox[{"sin", "(", 
         RowBox[{"a", " ", "kappa"}], ")"}]}]}]]}], ",", 
    RowBox[{"B2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"A1", " ", "k", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "a", " ", "k"}]]}], 
       RowBox[{
        RowBox[{"k", " ", 
         RowBox[{"sin", "(", 
          RowBox[{"a", " ", "kappa"}], ")"}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "kappa", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"a", " ", "kappa"}], ")"}]}]}]]}]}]}], "}"}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989359127378*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["sqTp = A3/A1 /. exprp", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "a", " ", "k"}]]}], 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["k", "2"], "+", 
       SuperscriptBox["kappa", "2"]}], ")"}], " ", 
     RowBox[{"sin", "(", 
      RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}], "+", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "k", " ", "kappa", " ", 
     RowBox[{"cos", "(", 
      RowBox[{"2", " ", "a", " ", "kappa"}], ")"}]}]}]], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989359269397*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transp=Simplify[sqTp ComplexExpand[Conjugate[sqTp]]]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"8", " ", 
     SuperscriptBox["k", "2"], " ", 
     SuperscriptBox["kappa", "2"]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["k", "2"], "-", 
          SuperscriptBox["kappa", "2"]}], ")"}], "2"], " ", 
       RowBox[{"cos", "(", 
        RowBox[{"4", " ", "a", " ", "kappa"}], ")"}]}]}], "+", 
     SuperscriptBox["k", "4"], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["k", "2"], " ", 
      SuperscriptBox["kappa", "2"]}], "+", 
     SuperscriptBox["kappa", "4"]}], ")"}]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893596384172`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transppl = Transp /. (kappa -> 1/a Sqrt[k^2a^2-1])", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"8", " ", 
     SuperscriptBox["k", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}], "-", "1"}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"6", " ", 
         SuperscriptBox["k", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["k", "2"]}], "-", "1"}], ")"}]}], 
        SuperscriptBox["a", "2"]], "-", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "-", 
           FractionBox[
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              SuperscriptBox["k", "2"]}], "-", "1"}], 
            SuperscriptBox["a", "2"]]}], ")"}], "2"], " ", 
        RowBox[{"cos", "(", 
         RowBox[{"4", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["k", "2"]}], "-", "1"}]]}], ")"}]}], "+", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["k", "2"]}], "-", "1"}], ")"}], "2"], 
        SuperscriptBox["a", "4"]], "+", 
       SuperscriptBox["k", "4"]}], ")"}]}], ")"}]}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893597570753`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series[Trans,{kappa,0,2}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["k", "2"]}], "+", "1"}]], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["kappa", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}]}], ")"}]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["k", "2"]}], "+", "1"}], ")"}], "2"]}]], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["kappa", "3"], ")"}],
     SeriesData[$CellContext`kappa, 0, {}, 0, 3, 1],
     Editable->False]}],
   SeriesData[$CellContext`kappa, 
    0, {(1 + $CellContext`a^2 $CellContext`k^2)^(-1), 0, 
     Rational[-2, 3] (1 + $CellContext`a^2 $CellContext`k^2)^(-2) (
      3 $CellContext`a^2 + 2 $CellContext`a^4 $CellContext`k^2)}, 0, 3, 1],
   Editable->False], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989359902568*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Series[Transp,{kappa,0,2}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["k", "2"]}], "+", "1"}]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["kappa", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["k", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}]}], ")"}]}], 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["k", "2"]}], "+", "1"}], ")"}], "2"]}]], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["kappa", "3"], ")"}],
     SeriesData[$CellContext`kappa, 0, {}, 0, 3, 1],
     Editable->False]}],
   SeriesData[$CellContext`kappa, 
    0, {(1 + $CellContext`a^2 $CellContext`k^2)^(-1), 0, 
     Rational[2, 3] (1 + $CellContext`a^2 $CellContext`k^2)^(-2) (
      3 $CellContext`a^2 + 2 $CellContext`a^4 $CellContext`k^2)}, 0, 3, 1],
   Editable->False], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893599423237`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpl /. a-> 5", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", " ", 
     SuperscriptBox["k", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"25", " ", 
        SuperscriptBox["k", "2"]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"25", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["k", "2"], "+", 
           RowBox[{
            FractionBox["1", "25"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"25", " ", 
               SuperscriptBox["k", "2"]}], "-", "1"}], ")"}]}]}], ")"}], "2"],
         " ", 
        RowBox[{
         SuperscriptBox["sinh", "2"], "(", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"25", " ", 
             SuperscriptBox["k", "2"]}]}]]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["4", "25"], " ", 
        SuperscriptBox["k", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"25", " ", 
           SuperscriptBox["k", "2"]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["cosh", "2"], "(", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"25", " ", 
             SuperscriptBox["k", "2"]}]}]]}], ")"}]}]}], ")"}]}], ")"}]}], 
  TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989359971566*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["p1=Plot[(Transpl /. a-> 5),{k,0,1/5}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkWk4FAoDhaW64qqkyTI0KLe0KUSLmoOypS6NXSrrpUzNYChlyVZxqSGR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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->NCache[{{0, 
       Rational[1, 5]}, {0., 0.4999999761904765}}, {{0, 0.2}, {0., 
      0.4999999761904765}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893601017838`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["p2=Plot[(Transppl /. a-> 5),{k,1/5,2}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw91Gk4VmkcBnCZlCxRNGViLJk2S2VKSdyizRYJUUnWioS0SBgpFdE1Uqi0
iKKyy0UkW0mIEe85513QJkI9lSWFzDNf5sO5zvX7eM7/vm91d387L3ExMTFX
+vz3nq9a9Eq3nAeOV7tlVR1Bybtipzc1PKRO41IHnhO8s/m0XtTIg13lmX7V
RoIZZZp/MjwedD3Nrhk1EfjEx8vWd/Ng6hcgvvklgYqxb3W+NAPt/S2RdXyC
ZNfWoAOzGDhVB9XdExIonjD8Q0uVwaSy9tqwdgKpJ9Jn0/UYPIg43Dv8iiCq
K8jAbQ2DQo242GtvCMSminpVNjCQ8zR+veIdwbB5lnWSM4Pj+4IT13QTBPoq
Tmz1YNBtVeB/v4egPzY0T96PwRve+36ZXoK3zVYKMREMAlMfPc7sJ/jH4SMX
msFgrqLhTIsvBJZHHWIM8hmYCrTc7L8S1CaXGw6XMhj5OKy8dYDgkTDuun8T
g4uvlxTpDhGsHB+y0eYYHDE1H5ceJij4fdekD68ZhIsSojuo77rperoPMXho
LWviOUKgeTJxluoEg81Kp1tmfye4mf6zVijJItX4yeEq6rm13sHJM1kIP093
dftBkNjdtMhBmUVcg3rFN+oZ01YKZ8xnoSOr8+zUKEHs4huxTUtYiAt4GZJj
BJF+/mSjGYt1fR0FQ9Tj59mbk61ZtJe1GbqOEwTnwa7KkcVYb8L2SurBloxf
wnez+CEvZ6T0k8B/QK5otQ+LT4JceR/qXsVg729BLGQitokXUnvrv5r9IIyF
lZGr8SD1622bngecYSHNJn/WmSDYeSwvRCeexSM1m3W7qdkrc7R7r7CQj9ng
eY7a7lFE+510Ftn55SG51C/ae8575LDQHffLb6TeNGFrolbCYop+7LK31DVq
D7+Iqlj4aj2fN0BtbKqedrmBRaeTXd4YdalHtL0jj4Vy/MufE9Qror5IKHSy
OJJ9UH+cOu+Oc3FzD4vlawVhg9TadVV7Y7/S77NdOtpFnfFh0W/mYyyKZZXb
Wqg1pC80SEzhwCY81Smhvqb9I7RajsNQFqN9mXrOZnfdv5Q4xF46PnSIOsG/
vtNwHoeopx73Lamnx+vFj2hzaCirDlShji64YlqkzyG10da3l/6vyW3ig4Em
HAq/WpYWUEcM+dzWteBQdSs44gj16K+tjn1bOZxO1ehcQX1klaFkpgsHCZHK
t8/0Xl+d0x567uHQt/ZZTwZ1T0qQckcIh6lnLbhp1FHqWocGT3JQGFgjKKX3
17jzpkEqjoNRc//dvdQuuVuOr7zBQeXsIsUymp+XVUsEf9dwCJdhs4xovgI2
dC/LaOSQdVFQzNI8yjZcjy7ncTAxNrP0p97UJmvQ281B6cs+9ySa5/L3fUlm
Mnw8zTl66wXN+3bfNOI8iw/bx7ZmjtQjZPvGgN/5SFlYObOd9kXv+/PhlKV8
SErnxXQNEmRKZzoM2/OhYhXW95b27cJST4W71/jIju3vuv2JYGnRXN+KO3w8
SCp9r0T9wqC1mpfLx6KaHYvjPhJImpkeFK/mI8AkuyiQ9jnMQa1lx3s+dpwL
8l9O+743RHR++hIBbhSEr8rqIjB6Yi91qFKAxmea1sUigoUTRvOt6wWQykjw
UqNWXL3AdH6bAKGzOyxj6D71534/xnULcCpywb3dAoKUq9c/rJEToq41vWQO
RzB2sKdOYpcQlgdEOeWt9B7ZLe869gjhHCclWEnd1lMqVhIoxOMHNk6FdA+z
dsWt8okSYv3Vij05LbQvFnqZTVlCJFp5hxQ1031RDz2TNCqErdQlORm6r5k7
vdICJEQITgmZcr2B4GLS5gpzORFumwzdXEa9X1b926iGCGVXbja51BMof3/q
vdtCBE3XDK96ut+Sy3MjDexFODGs37qPeutC60gXZ9H/+/4vuOhFKA==
      "]], 
     LineBox[CompressedData["
1:eJwl23k4VG8bB3AhSrYkQgpF0kKokNySKFuREElJtpAtkbTZi5IilbQhZf1J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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0.5, 0.994},
   PlotRange->NCache[{{
       Rational[1, 5], 2}, {0.9931909177018339, 0.9999999999309732}}, {{
      0.2, 2}, {0.9931909177018339, 0.9999999999309732}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989360381425*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[{p1,p2},PlotRange->{{0,2},{0,1}}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkWk4FAoDhaW64qqkyTI0KLe0KUSLmoOypS6NXSrrpUzNYChlyVZxqSGR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       "]]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw91Gk4VmkcBnCZlCxRNGViLJk2S2VKSdyizRYJUUnWioS0SBgpFdE1Uqi0
iKKyy0UkW0mIEe85513QJkI9lSWFzDNf5sO5zvX7eM7/vm91d387L3ExMTFX
+vz3nq9a9Eq3nAeOV7tlVR1Bybtipzc1PKRO41IHnhO8s/m0XtTIg13lmX7V
RoIZZZp/MjwedD3Nrhk1EfjEx8vWd/Ng6hcgvvklgYqxb3W+NAPt/S2RdXyC
ZNfWoAOzGDhVB9XdExIonjD8Q0uVwaSy9tqwdgKpJ9Jn0/UYPIg43Dv8iiCq
K8jAbQ2DQo242GtvCMSminpVNjCQ8zR+veIdwbB5lnWSM4Pj+4IT13QTBPoq
Tmz1YNBtVeB/v4egPzY0T96PwRve+36ZXoK3zVYKMREMAlMfPc7sJ/jH4SMX
msFgrqLhTIsvBJZHHWIM8hmYCrTc7L8S1CaXGw6XMhj5OKy8dYDgkTDuun8T
g4uvlxTpDhGsHB+y0eYYHDE1H5ceJij4fdekD68ZhIsSojuo77rperoPMXho
LWviOUKgeTJxluoEg81Kp1tmfye4mf6zVijJItX4yeEq6rm13sHJM1kIP093
dftBkNjdtMhBmUVcg3rFN+oZ01YKZ8xnoSOr8+zUKEHs4huxTUtYiAt4GZJj
BJF+/mSjGYt1fR0FQ9Tj59mbk61ZtJe1GbqOEwTnwa7KkcVYb8L2SurBloxf
wnez+CEvZ6T0k8B/QK5otQ+LT4JceR/qXsVg729BLGQitokXUnvrv5r9IIyF
lZGr8SD1622bngecYSHNJn/WmSDYeSwvRCeexSM1m3W7qdkrc7R7r7CQj9ng
eY7a7lFE+510Ftn55SG51C/ae8575LDQHffLb6TeNGFrolbCYop+7LK31DVq
D7+Iqlj4aj2fN0BtbKqedrmBRaeTXd4YdalHtL0jj4Vy/MufE9Qror5IKHSy
OJJ9UH+cOu+Oc3FzD4vlawVhg9TadVV7Y7/S77NdOtpFnfFh0W/mYyyKZZXb
Wqg1pC80SEzhwCY81Smhvqb9I7RajsNQFqN9mXrOZnfdv5Q4xF46PnSIOsG/
vtNwHoeopx73Lamnx+vFj2hzaCirDlShji64YlqkzyG10da3l/6vyW3ig4Em
HAq/WpYWUEcM+dzWteBQdSs44gj16K+tjn1bOZxO1ehcQX1klaFkpgsHCZHK
t8/0Xl+d0x567uHQt/ZZTwZ1T0qQckcIh6lnLbhp1FHqWocGT3JQGFgjKKX3
17jzpkEqjoNRc//dvdQuuVuOr7zBQeXsIsUymp+XVUsEf9dwCJdhs4xovgI2
dC/LaOSQdVFQzNI8yjZcjy7ncTAxNrP0p97UJmvQ281B6cs+9ySa5/L3fUlm
Mnw8zTl66wXN+3bfNOI8iw/bx7ZmjtQjZPvGgN/5SFlYObOd9kXv+/PhlKV8
SErnxXQNEmRKZzoM2/OhYhXW95b27cJST4W71/jIju3vuv2JYGnRXN+KO3w8
SCp9r0T9wqC1mpfLx6KaHYvjPhJImpkeFK/mI8AkuyiQ9jnMQa1lx3s+dpwL
8l9O+743RHR++hIBbhSEr8rqIjB6Yi91qFKAxmea1sUigoUTRvOt6wWQykjw
UqNWXL3AdH6bAKGzOyxj6D71534/xnULcCpywb3dAoKUq9c/rJEToq41vWQO
RzB2sKdOYpcQlgdEOeWt9B7ZLe869gjhHCclWEnd1lMqVhIoxOMHNk6FdA+z
dsWt8okSYv3Vij05LbQvFnqZTVlCJFp5hxQ1031RDz2TNCqErdQlORm6r5k7
vdICJEQITgmZcr2B4GLS5gpzORFumwzdXEa9X1b926iGCGVXbja51BMof3/q
vdtCBE3XDK96ut+Sy3MjDexFODGs37qPeutC60gXZ9H/+/4vuOhFKA==
       "]], 
      LineBox[CompressedData["
1:eJwl23k4VG8bB3AhSrYkQgpF0kKokNySKFuREElJtpAtkbTZi5IilbQhZf1J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       "]]}}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 2}, {0, 1}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893604285383`*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["p1=Plot[(Transpl /. a-> 2),{k,0,1/2}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVk2k41A0bxanex2gh0kLWQilNFCpqTsiuYhDCNLYSMtZKhYgWjZJEITRG
QoxdZKvEo7LEWLLMv4SsaZOKeD0fznW+nPt3X/d9XUfOiUF1XcTHx5e2oP/c
2HX4bc2IHqXy7uaVMftZe5foSngT4vKo9u0qCyulUXam3E0qFFfD3nvTu/+W
BFMGJOVDzyhSsMJbqKJd/xbFpLGz4L74AcRrSPFXlCRT5JlS6fMyRlD7t8q7
bC6DMmvsHO+oeAjHBagdVfr5lNFwbq1jnDkeFCpmtF8qpVi7TFfGiFtiudZQ
xIOSKkqtrkTpi6QjUHdpPHWL8YKisnFf3g8ZW3z5kiGcM1dPSVpEz1RIs4OA
huBYGqmRQuoPYx1RpIGxtUL+qf5bSvn71sYXlnS8j63aF6PPpXibuRjbxzlC
WsrMs/NSJ6Vv+xXdKHEXEJ6Frx6X8CixKetqFOxc0VVfny995APFWDhrb1XS
cZi9FPBNZnyklHx+oz4pcxJdX41e1c59onjSaAVXHN2hxG1le/iPUjY0TZJl
0zzQsFTr7CvSBOVGjuhmc0UvPLg2a9al/5WiJ8Vmj5xgQOG+h7xk9TdKcF3C
ymeW3liV33qgQv8HRU1DOco2zgebnArqRMKnKamrD1+OFPeH3aoPp8VK5yjn
G+Nrj5T7Y8hoeZa0FR+ORLxftNEuAJbrOWzHI/xYPuUT8jTpNA5lywZ+ZyzG
WW7s2XGZQCR6dlgazgvAgtlX8qQmED9VKjuoGoIgH1CcCnc8B3MzzePLA5Zi
oLDURyrtPAIKV04zBVfA/Ha3+yHFYPyVVJ11MhCBssnGTIn6YFhXCgen84uC
tNjz09CJEHDKL7VXV4viWNlcfrXlRRg8K1O5YCCG1UrRZJu4UBBBYe1iEWsR
SircdE08HMtn4wNbnkhji8GtqwXe4Ug80Cad8FIGrRGMkZ76cNzbKRzi7yEL
+cXK2eTTEWg0UDt6/ZIc6v6yydzWy6CuyxXsbtqI5d/j1GWY19DtWCyxpHUz
ilUD4gw/XgMqn9nHX1ACzdti2kczEjW3PN6fUtoCzoRwWe1wJKY+kHoGrm0F
dfjqXnc9JiRZs6MzrmTc7TunWzx3Aw0Oz/M89XZAW9KWzbO6ibxJP7Q93oHR
o7v+R8q5CY5bMtdu9U5Ijwc652yLhvCkF7ltZCcYJzUU+HqjYb20wM0uVR2i
LpxH6btjUGHz90KX7h7Y2D7gfPkai0fPXdm0gv2Y7LFcypK4A/39uxD7fT8u
00iuFrp3cH6EW2aoro1CZ4ZESewdWDm1OJDLtSHktS/i/K44BOcPNY436OBl
2Luj/wTFI5pa3byHXw87Hov8I0lKwA0DfFJtNkID+SW9USUBMfw+Z0xkjUHP
P/s02DYBLl7HvAd8jBFVQnh/yEpAX1AIJ3aNCYZrcnoeHkzEGZu6kc+upkhu
N8pXvZ2EX61hyTckD2PZfKi9gXQKaKWDl5v9qbh70pqmrJ+CDcmhJ53ZVMhz
lekiXilw/TzaocalgpLZ6dxTmYKp6D77aDULlGXGFZeSU7FvhuS45ZcFJizG
K0yaUtFeOFg4HmkFq0fxr/1WsDCzei6simeDJIcw0+NyLKT+mFMRXGOLftFT
jTbqLARor6q7ddAWjCCd5n0OLHixBvLtK21xjTrRKpDDwnXZL5/epRxF5axO
d6JpGnIWr4/397aHgvnn4RfX2RhIa+GTk6VDIsRA88QDNkqdv3ha6dCxMif1
+tJSNi6X7b6U60LHH5IF2byfDa0jpqVNmXS01JT68Xan44aYXlC9uiPOqYTO
/RpMxyrtoMtJlk5oEhYTI+/PwI4hE63BHBecadqDuz8ysU5CjhHcfBJC5OLB
BlIW3g2uMBD8dRLsKBXmjGQWdjkpJxXJuuOt6aZ3NL0sXPQwqPf0dcfW12J+
CnFZ2Fxw1Ml5rQeI+smHBbuykda3ttLjhOdCz9KFGs89hk1Y3sRvGQbWFonw
+Pk5mIgLr34T6At75ozlwBoO2s4xEzVifcFyGXxdp8yBUZnbWGGuL5RXl5Vd
t+HglFv+xPBHX+icpt9ZnccBk26Wu/ewHzSSrB/Gbs9DQCO1gKnkD0faQ4dH
vDxE0hyTesYDUNKv+6Z5bwGsR1jdKbmBeO5+f73teBGaT29bNj9zEVOK+4Rz
TpUik1JSknEiAot+Z69cr1AOJavytHutkdCYp5dY5FZAfxOf2gZKNN6EqzXV
bamGysGXn+oO34ZM9NjvzM81GOCrs6POxGFsmuC1qzzHeOz4+vcVCWCPPn0l
dOMFHNbpdYRsT4GQVMbkwEAteuRF/fx+PwDzZPHxVPk6hEwdrHB0ZOPn/uwB
t5B6HApXzqTuzID/jtqiNS/+RfIYnGYFs0Dk1l5/K/cKppbW87dsczDjzk1U
OvcaO9YvVy30zMNWbYG540/fwF6smjBSLoABS+5E/tomjJlsLmfsLMIZqWMb
Ptg3o9THT9NiTwmUx62WdR5swTf2xGF/qydYJfyFVPunBWZV39PJL8uxpDqR
szHpLQrvzf5arVIJD7Wn7wRNWtEc9aw49lc1so2cUqt+tkL3+bavw4xnmBqT
WDkU1wavnVxGGe85ii0MFsce4OLU9/mjWpdqEWIYkVI0xAXN2FU1V64Ocn3G
XWkR7dD5ETb69009NHeFx4rv6ICPp74+p6gB9tLNv/nbOnDqA9M7IeY1pl5F
9XuHdsLP2YzvS34j7i6h+VPlu7BscLRZ9mUzVvGKWYtqu+DzWlNP5lsL/hcU
arnH5x3MPqaeW6vQCr5MGqdftBtesyL8Iofb4JvAiRJ93g0JVQH/bclcVG69
ShLx6oFCaDtV4ns7RIx9lcOEevHewsrEUKsTvdta2gIreuE7ZfjtSmYX8pIh
P0Drg7lqpXwQqRsOHA0Rqbk+LIthVqi59eBixIPQ3iwefmr+ybad6EXOsFSi
kCmByJ8dU+dpPFy9H0HnHSLg0b/98bQLDy7UCYVccwIBbPVqPw8eJCsq8g5a
E6iwz/jteZaHyJt2dUwnAsaPy4qcY3hw07j3dWkggTMj7Z8c63jYEC5mKPCQ
gFtnqn0ymcDc7gsrOh8RyLhi1SuvTuDdxMfWh9kERPt9srO1CERbFzro5xPo
n92uUW5IYH4L1S+igsA/tsTX7oU9vW9vJi9uI6A5FsnaEk/gyeVp57Z2Auo/
0weL7xOI1TqmlNZFoNHBwkebTcAknVykw1vIBWfTbRe45WcbG0JHCERx1G8z
XxOI26Z+03ycALG5QUiilYBPf5Kl3CSB21pnmzMWOJtNPYmaHwQWjpeuHSSw
hJ/Ljp4mYOfVkk1dmHtfrOVO/0Og/XHMhQ/fFv7inrZd5S+BvyY60d6/CcTL
LJuanydQZsQY+s//D3L/9Kk=
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->NCache[{{0, 
       Rational[1, 2]}, {0., 0.49999997619047637`}}, {{0, 0.5}, {0., 
      0.49999997619047637`}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989360579052*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["p2=Plot[(Transppl /. a-> 2),{k,1/2,2}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Xk4VV0XAHCJRMYUlUKKSqWkQcLKEEqIBiFDEjJEA5kqicqUIjIllUKE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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0.6000000000000001, 0.9},
   PlotRange->NCache[{{
       Rational[1, 2], 2}, {0.8904354607922202, 0.9999999995823081}}, {{
      0.5, 2}, {0.8904354607922202, 0.9999999995823081}}],
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.476989360754249*^9},
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show[{p1,p2},PlotRange->{{0,2},{0,1}}]", "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVk2k41A0bxanex2gh0kLWQilNFCpqTsiuYhDCNLYSMtZKhYgWjZJEITRG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       "]]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd2Xk4VV0XAHCJRMYUlUKKSqWkQcLKEEqIBiFDEjJEA5kqicqUIjIllUKE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       "]]}}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 2}, {0, 1}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}], TraditionalForm]], "Output",
 Evaluatable->False,
 CellChangeTimes->{3.4769893608132763`*^9},
 AspectRatioFixed->True]
}, Open  ]]
},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{Automatic, 188}, {Automatic, 62}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"XAutomaticEncoding",
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "iso8859-1"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 46, 1, 42, "Input"],
Cell[594, 23, 81, 1, 42, "Input"],
Cell[678, 26, 89, 1, 42, "Input"],
Cell[770, 29, 67, 1, 42, "Input"],
Cell[840, 32, 190, 5, 78, "Input"],
Cell[CellGroupData[{
Cell[1055, 41, 82, 1, 42, "Input"],
Cell[1140, 44, 2987, 82, 245, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[4164, 131, 62, 1, 42, "Input"],
Cell[4229, 134, 2888, 81, 245, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[7154, 220, 61, 1, 42, "Input"],
Cell[7218, 223, 815, 24, 65, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[8070, 252, 91, 1, 42, "Input"],
Cell[8164, 255, 831, 27, 65, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[9032, 287, 61, 1, 42, "Input"],
Cell[9096, 290, 962, 29, 87, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[10095, 324, 85, 1, 42, "Input"],
Cell[10183, 327, 1028, 32, 87, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[11248, 364, 91, 1, 42, "Input"],
Cell[11342, 367, 1694, 55, 163, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[13051, 425, 89, 1, 42, "Input"],
Cell[13143, 428, 203, 5, 78, "Input"],
Cell[CellGroupData[{
Cell[13371, 437, 93, 1, 42, "Input"],
Cell[13467, 440, 2879, 81, 245, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[16383, 526, 63, 1, 42, "Input"],
Cell[16449, 529, 741, 21, 63, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[17227, 555, 94, 1, 42, "Input"],
Cell[17324, 558, 791, 25, 65, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[18152, 588, 92, 1, 42, "Input"],
Cell[18247, 591, 1687, 55, 135, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[19971, 651, 67, 1, 42, "Input"],
Cell[20041, 654, 1265, 38, 62, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[21343, 697, 68, 1, 42, "Input"],
Cell[21414, 700, 1266, 38, 62, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[22717, 743, 58, 1, 42, "Input"],
Cell[22778, 746, 1504, 50, 131, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[24319, 801, 79, 1, 42, "Input"],
Cell[24401, 804, 3993, 74, 239, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[28431, 883, 80, 1, 42, "Input"],
Cell[28514, 886, 21885, 368, 236, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[50436, 1259, 80, 1, 42, "Input"],
Cell[50519, 1262, 25286, 425, 241, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[75842, 1692, 79, 1, 42, "Input"],
Cell[75924, 1695, 3991, 74, 241, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[79952, 1774, 80, 1, 42, "Input"],
Cell[80035, 1777, 13639, 231, 236, "Output",
 Evaluatable->False]
}, Open  ]],
Cell[CellGroupData[{
Cell[93711, 2013, 80, 1, 42, "Input"],
Cell[93794, 2016, 17021, 288, 241, "Output",
 Evaluatable->False]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

