(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52326,       2909]
NotebookOptionsPosition[     50837,       2855]
NotebookOutlinePosition[     51176,       2870]
CellTagsIndexPosition[     51133,       2867]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Decaying exponentials for increasing well depth", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"ysub", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ka", "\[Rule]", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["k", "2"], "-", 
          SuperscriptBox["y", "2"]}]]}], "}"}], "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         SqrtBox[
          RowBox[{
           SuperscriptBox["k", "2"], "-", 
           SuperscriptBox["y", "2"]}]], "==", 
         RowBox[{"y", " ", 
          RowBox[{"Tan", "[", "y", "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "1.3"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "2.", ",", "10.", ",", "1."}], "}"}]}], "]"}]}], 
  TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "1.71446053664826987`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "2.76239333806161857`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "3.79889607350388347`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "4.82630443554189803`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "5.84736219384075628`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "6.8639620913089816`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "7.87735197960939981`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "8.88836683387291159`"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ka", "\[Rule]", "9.89758030626200913`"}], "}"}]}], "}"}], 
  TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], ",", 
      RowBox[{"x", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1."}], "}"}]}], "]"}], 
  TraditionalForm]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.377938 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .1092 -24 -4.5 ]
[.01131 .1092 0 4.5 ]
[.01131 .20368 -18 -4.5 ]
[.01131 .20368 0 4.5 ]
[.01131 .29817 -24 -4.5 ]
[.01131 .29817 0 4.5 ]
[.01131 .39265 -6 -4.5 ]
[.01131 .39265 0 4.5 ]
[.01131 .48714 -24 -4.5 ]
[.01131 .48714 0 4.5 ]
[.01131 .58162 -18 -4.5 ]
[.01131 .58162 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .1092 m
.03006 .1092 L
s
[(0.25)] .01131 .1092 1 0 Mshowa
.02381 .20368 m
.03006 .20368 L
s
[(0.5)] .01131 .20368 1 0 Mshowa
.02381 .29817 m
.03006 .29817 L
s
[(0.75)] .01131 .29817 1 0 Mshowa
.02381 .39265 m
.03006 .39265 L
s
[(1)] .01131 .39265 1 0 Mshowa
.02381 .48714 m
.03006 .48714 L
s
[(1.25)] .01131 .48714 1 0 Mshowa
.02381 .58162 m
.03006 .58162 L
s
[(1.5)] .01131 .58162 1 0 Mshowa
.125 Mabswid
.02381 .03361 m
.02756 .03361 L
s
.02381 .05251 m
.02756 .05251 L
s
.02381 .07141 m
.02756 .07141 L
s
.02381 .0903 m
.02756 .0903 L
s
.02381 .1281 m
.02756 .1281 L
s
.02381 .14699 m
.02756 .14699 L
s
.02381 .16589 m
.02756 .16589 L
s
.02381 .18479 m
.02756 .18479 L
s
.02381 .22258 m
.02756 .22258 L
s
.02381 .24148 m
.02756 .24148 L
s
.02381 .26037 m
.02756 .26037 L
s
.02381 .27927 m
.02756 .27927 L
s
.02381 .31707 m
.02756 .31707 L
s
.02381 .33596 m
.02756 .33596 L
s
.02381 .35486 m
.02756 .35486 L
s
.02381 .37376 m
.02756 .37376 L
s
.02381 .41155 m
.02756 .41155 L
s
.02381 .43045 m
.02756 .43045 L
s
.02381 .44934 m
.02756 .44934 L
s
.02381 .46824 m
.02756 .46824 L
s
.02381 .50603 m
.02756 .50603 L
s
.02381 .52493 m
.02756 .52493 L
s
.02381 .54383 m
.02756 .54383 L
s
.02381 .56273 m
.02756 .56273 L
s
.02381 .60052 m
.02756 .60052 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .39265 m
.02499 .39265 L
.02605 .39265 L
.02729 .39265 L
.02846 .39265 L
.03053 .39264 L
.03279 .39264 L
.03527 .39263 L
.0379 .39261 L
.04262 .39258 L
.04749 .39254 L
.05205 .39249 L
.06244 .39234 L
.07305 .39215 L
.08274 .39193 L
.10458 .39129 L
.12357 .39057 L
.14429 .38962 L
.18493 .38721 L
.22406 .3842 L
.26565 .38027 L
.30571 .37572 L
.34426 .37062 L
.38527 .36438 L
.42475 .35753 L
.46273 .35012 L
.50315 .34129 L
.54206 .3318 L
.58342 .32053 L
.62326 .3084 L
.66159 .29539 L
.70238 .27991 L
.74164 .26309 L
.77939 .24478 L
.8196 .22234 L
.85828 .19686 L
.89942 .16337 L
.91995 .14267 L
.93905 .11923 L
.94829 .10553 L
.95701 .09019 L
.96183 .0801 L
.96706 .06693 L
.96937 .05988 L
.97181 .05093 L
.9739 .04094 L
.97508 .03295 L
.97619 .01482 L
s
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.03053 .01473 L
.03279 .01475 L
.03527 .01477 L
.0379 .0148 L
.04262 .01486 L
.04749 .01495 L
.05205 .01505 L
.06244 .01534 L
.07305 .01573 L
.08274 .01616 L
.10458 .01744 L
.12357 .01888 L
.14429 .0208 L
.18493 .02564 L
.22406 .03168 L
.26565 .03962 L
.30571 .04883 L
.34426 .0592 L
.38527 .07193 L
.42475 .08596 L
.46273 .1012 L
.50315 .11945 L
.54206 .13916 L
.58342 .16263 L
.62326 .18795 L
.66159 .2151 L
.70238 .24734 L
.74164 .28208 L
.77939 .31937 L
.8196 .36391 L
.85828 .41221 L
.89942 .47047 L
.93905 .5346 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztWllsVUUYPr237e1KsbRAodrbja20VJQClkJVaCWkRowkJMTlBqpsChSU
IEkTxVSJaMCIaBBXgqAoVowmPvjgg28+u8R9icZ9315qZ+7td86dfv+cM6XG
F2+a28m3/P/MnDlnlnN7Urs29t6c2rVpfSrZ3ZfavnHT+p3Jrm19w1A8x/Ny
kp7nDSY9VR4aLma+hob/hmrVl0Lcyl3qX0yFydVA3EuH1Bovpr5zFdJg1TGs
3uqIg7VH9nVzUJf8dNVXZFIH5cOfAhKlgUuLiLTOFnUU7KZuIvnyrI0plDp2
tDShCnmqJAj+oyY4dHKCw8LV0zWMWxpciLEz17nWxcRRG23AhVU52uV07//p
hJrpFDy0H/+1Zs3GtUzIjZmFehSh1IgSu2L12Q5/sBhRLOODVWQoHSwSX6H+
6TaWag01sNtcPw2L0P8RHOxOY9j/Xq6zXPFp6rtQISWEbY2IzYuos1SkHqPi
LTdjs/pOKOTNEKO+Ixaokr5N33DLswjG192MS2B8zc3Yqb7zFfKym7ELGc8Q
Nt/sklWqpDWnQ+QG1YM8J92Mq5HxOGEtT8prkPEJN+NaGB8NMeouuRYVfJjI
C+Q81yPEQ27GFDI+QNhC2bgBGQ+6GW9ExgOELTK7ZDPk+0PkBrUVIe52M96C
jPsIWywbdyDjHbIxBpF9gxBDLfKIbiei9BM2/UwdcQYZ9WGri3ypLjrHbSjt
JbpSazY2WbAWxQi2G3n3OOdNX+DshZGtR/dkt9ZgJ1hzFZNc3sjSKzvQXlSi
j7BlES7cqDSs51gL+9HCbYSdaA5PfzUXx6DMzR7hurSVBDtPvknuhHGzm/Eu
GG8ibLlsHIBxA2EnycZ7YEwRtiJg1KJ7UbqOyCvlPAdgXEfYybLxfhjXEnaK
bDwI4xrCTpWNbJJYTbAqs3MeROkqIp8mZzxMsFUIdr5sZBPhSoJZQhxBnisI
e4FsfIRgywlWY3bTUZQuJ/KknJEtL5YiWL1sPAZRB2EtxscJtphg6T1u+uFl
n/fEZzNbdLUhXnpPLh12sG2s/5B7CqUFRDfGyAb2NMFakXeONYd/JsP65Tii
sJ1QhMgRZo0TBGOHJk3jku0ZgvnHFC3mUNKLC2NmOmUMjOxgLfKAfpZgdQh2
oWx8jmA1MF4kG9m+p9oYkdT4PMGqYFwYMGrgDEpTUFosR3+RYOUwtsvGQYKV
wdghG18iWAmMy2TjWYj85cqlZvNfkQZf4EFLozOj/+xYIRtfxbjsDomuoZUh
DdSQf3LfbTZwECJ2ny2Xo7+AEOwYxtIzp2EsI+xlITeZNpYTNnPp7HukuHRV
xOfkScSrJGxnOul47F90jhOoy1SiW2bNxo7RxPnSwJ7EoKsm7NIIeaPvlh4D
W0vYDmsuh93SUaRpJOwSa5pz3C0dQW/OJmy7OVD9mcjfwvtz0mG0o4UEu0S+
XQ7BOJ+wlmf4fahFG2EXycb9MLYTdqFsHEBVOwnbFjDqLtmHPGxhbJn7+mFk
q/mLZePtMPa4GW9V3/pN4NWEtczv22Fk+7P5ZpdsUSV98Mo2kJYFSC/y9BK2
VTbeAOMWws6Tjetg3EFYyyJrDdq4m7DNZpdcqUoFqsTOuebKefTcpc/1B9yM
+tYoVsghwjbJxmYYjxE2sxifhDEovuLXlT5F2PRziE5hekqcoZCzYzAa2NsE
m+UW4h2CzXQL8S7BZgQ6UZyaLMaoud8jWKM5NN8nogZ5eDC5ZXftKP+AYHWy
/EOC1ZoN/JiIknLMj9zkLHqNLP+EYJYDmE8JFjzo0Q38LERkUExeLcs/J9h0
Wf4FwSzHYmFy3cAviahKjsnklrNAizxzV418/FNktoyN8LrjK4JljjdZWLaU
FN9wnFuqqAcb/krxa8JOlhOk9x/RV+YsfKUcni38Pb4Yt0TOzGaBD6u2F331
/Q3BKkKuAntXET2sf9d8R0SWtwTfuslZdMvLi+8JZnlJEibXDfyRiCbKMX9w
k7PoZbL8J4JNGLtcN/AXIiqVY/7sJmfRS8ZN/ivBgu+cdQN/CxEZFJNbXoBb
5AncXu6nML8TLPM7gai/KGKPj/EKqzv2T8IWyMES1gb/MYZgEZ6NrI6JwOXR
TNRjK0swsY7i4/Uvgo362c/fISKDYvJx+ilhGK/L5DfeXs4//3AWKg==\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.143116, \
0.00394728, 0.00994691}}],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
   False,
   Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SqrtBox[
       RowBox[{"100", "-", 
        SuperscriptBox["x", "2"]}]], ",", 
      RowBox[{"x", " ", 
       RowBox[{"Tan", "[", "x", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], 
  TraditionalForm]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.606305 0.0147151 0.00834847 [
[.17539 .00222 -12 -9 ]
[.17539 .00222 12 0 ]
[.32696 .00222 -9 -9 ]
[.32696 .00222 9 0 ]
[.47854 .00222 -12 -9 ]
[.47854 .00222 12 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -12 -9 ]
[.78169 .00222 12 0 ]
[.93327 .00222 -9 -9 ]
[.93327 .00222 9 0 ]
[.01131 .0982 -12 -4.5 ]
[.01131 .0982 0 4.5 ]
[.01131 .18168 -12 -4.5 ]
[.01131 .18168 0 4.5 ]
[.01131 .26517 -12 -4.5 ]
[.01131 .26517 0 4.5 ]
[.01131 .34865 -12 -4.5 ]
[.01131 .34865 0 4.5 ]
[.01131 .43214 -12 -4.5 ]
[.01131 .43214 0 4.5 ]
[.01131 .51562 -12 -4.5 ]
[.01131 .51562 0 4.5 ]
[.01131 .59911 -12 -4.5 ]
[.01131 .59911 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .01472 m
.17539 .02097 L
s
[(0.25)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(0.5)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(0.75)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(1)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(1.25)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(1.5)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .0982 m
.03006 .0982 L
s
[(10)] .01131 .0982 1 0 Mshowa
.02381 .18168 m
.03006 .18168 L
s
[(20)] .01131 .18168 1 0 Mshowa
.02381 .26517 m
.03006 .26517 L
s
[(30)] .01131 .26517 1 0 Mshowa
.02381 .34865 m
.03006 .34865 L
s
[(40)] .01131 .34865 1 0 Mshowa
.02381 .43214 m
.03006 .43214 L
s
[(50)] .01131 .43214 1 0 Mshowa
.02381 .51562 m
.03006 .51562 L
s
[(60)] .01131 .51562 1 0 Mshowa
.02381 .59911 m
.03006 .59911 L
s
[(70)] .01131 .59911 1 0 Mshowa
.125 Mabswid
.02381 .03141 m
.02756 .03141 L
s
.02381 .04811 m
.02756 .04811 L
s
.02381 .06481 m
.02756 .06481 L
s
.02381 .0815 m
.02756 .0815 L
s
.02381 .1149 m
.02756 .1149 L
s
.02381 .13159 m
.02756 .13159 L
s
.02381 .14829 m
.02756 .14829 L
s
.02381 .16499 m
.02756 .16499 L
s
.02381 .19838 m
.02756 .19838 L
s
.02381 .21508 m
.02756 .21508 L
s
.02381 .23178 m
.02756 .23178 L
s
.02381 .24847 m
.02756 .24847 L
s
.02381 .28187 m
.02756 .28187 L
s
.02381 .29856 m
.02756 .29856 L
s
.02381 .31526 m
.02756 .31526 L
s
.02381 .33196 m
.02756 .33196 L
s
.02381 .36535 m
.02756 .36535 L
s
.02381 .38205 m
.02756 .38205 L
s
.02381 .39874 m
.02756 .39874 L
s
.02381 .41544 m
.02756 .41544 L
s
.02381 .44884 m
.02756 .44884 L
s
.02381 .46553 m
.02756 .46553 L
s
.02381 .48223 m
.02756 .48223 L
s
.02381 .49893 m
.02756 .49893 L
s
.02381 .53232 m
.02756 .53232 L
s
.02381 .54902 m
.02756 .54902 L
s
.02381 .56571 m
.02756 .56571 L
s
.02381 .58241 m
.02756 .58241 L
s
.02381 .61581 m
.02756 .61581 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .0982 m
.02499 .0982 L
.02605 .0982 L
.02729 .0982 L
.02846 .0982 L
.03053 .0982 L
.03279 .0982 L
.03527 .0982 L
.0379 .0982 L
.04262 .0982 L
.04749 .0982 L
.05205 .0982 L
.06244 .0982 L
.07305 .0982 L
.08274 .0982 L
.10458 .09819 L
.12357 .09819 L
.14429 .09818 L
.18493 .09817 L
.22406 .09815 L
.26565 .09813 L
.30571 .09811 L
.34426 .09808 L
.38527 .09805 L
.42475 .09802 L
.46273 .09798 L
.50315 .09794 L
.54206 .09789 L
.58342 .09784 L
.62326 .09779 L
.66159 .09774 L
.70238 .09768 L
.74164 .09761 L
.77939 .09755 L
.8196 .09748 L
.85828 .09741 L
.89942 .09732 L
.93905 .09724 L
.97619 .09716 L
s
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.03053 .01472 L
.03279 .01472 L
.03527 .01472 L
.0379 .01472 L
.04262 .01472 L
.04749 .01473 L
.05205 .01473 L
.06244 .01475 L
.07305 .01477 L
.08274 .01479 L
.10458 .01486 L
.12357 .01494 L
.14429 .01505 L
.18493 .01532 L
.22406 .01566 L
.26565 .01612 L
.30571 .01666 L
.34426 .01729 L
.38527 .01809 L
.42475 .01901 L
.46273 .02006 L
.50315 .02138 L
.54206 .02292 L
.58342 .0249 L
.62326 .02726 L
.66159 .03009 L
.70238 .03398 L
.74164 .03898 L
.77939 .04563 L
.79874 .05013 L
.8196 .05619 L
.83964 .06375 L
.84984 .0685 L
.86074 .0745 L
.87108 .08133 L
.88048 .08882 L
.89884 .10865 L
.90883 .12394 L
.91803 .14268 L
.92813 .17148 L
.93322 .19112 L
.93883 .21891 L
.94366 .25052 L
.94824 .29063 L
.95235 .33976 L
Mistroke
.95468 .37587 L
.95684 .41711 L
.95937 .47905 L
.96176 .55718 L
Mfstroke
.96176 .55718 m
.96312 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztWTtvUzEYdV5tHuXV0iZpkjYFRIQqBBULA2IDpi6MbFFVqR0QqPSH8CvY
YWNhZISBBSGBEBKg8n6/IcRfgm96ez5fX183N0GtKsc6Pj4+/mx/8b1ZbK6v
LF9srq8uNevn1pqXV1aXrtTPXlprQ6mEEIm6EOJ6Xch6q13tFq32f2tOFhLB
9QX5kZT0NAEp0elKHJGUZVoiVKPGUnAPgspaXkrbt6bGraoa2wP50/cgaE8n
AMfpI72J1P7Lgr4jANuPuxcAdRJTc4CaAVgVYDWAjRo6LwIsD7AxbZxM3UeP
E/KGdpZpnNAKI+du4pQH8L+dWNRsQW9Lh9OcNYxCTqMxze0ug/NTwHDZ/LQx
k2aE5wzni2ImBNw06CB1Jz0Omiq6qW2Bk+xOixKcEIPV1EJ6NbQZmO4lXyfj
MFGkk2r7Uo0SNQ1bVFhOYSWAeYl/xnDhs2C0Mrfq1LqbnwSVY2bttGEpjhNq
dNwLZR9TDGX4vunNSwQdl6FwP8BeNJvlsCHWkGVRIqYqDYBN8EauynJKIss8
6ZosCxK50EOi43hD1rKydp7vf1OWGYks8qRbSukMT7oty1GJnPY7uaNqp/j+
d2VJ+eEkT7qn7J7gSffVcAs86YEiHfPbfahqR/n+jxRpnic9VqQjPOmJIjX8
Tp4C+iFeCdEP8vRnADvQoXupPKXMoPP2HGDdB6BM9/D1NlGDwF986KGCHFYk
ko8gusG11t053QDYrDv5FwCb6VmqlFqqrbcMlP9eAqzWaxc83HmbgGqvAa/K
b7ZX4ehIvcLT3wBs2p5OE3wHSGVe8204OlIv2dPJ8ftwmohejIv+AWBT/gl+
DCD5mhB90opumg+DJOBRNzqxnwDWefbnXxcxyuT+M6/nImEh+e5dZwRbc6DM
hFMXC3PxtAqdV/Oy4Re+I9pqmnEc0JGZcXs6TfCrW82hd4zU9/WNThP8FpcF
9ij46Mjg3o6ExVGlYb7zkhHzisasN8sQCVujt31Oo2dAozCgDPgDdNS8rkIL
2T/68DnuwwQRXfOuzjGdHP+M1YI53eAhKaxYyPtWULioY8aTMDr8GpOMSoiE
qBH3Zzl3ylapO9rCD9VGHr6jZz3BX4C0i9dE8egfPV7H3jsl/QVPIxHxjuNQ
OSiUVi/QgoIHpzjgyuj9hs0+RHTNb3rx0mmCv3ccDxA93gmaPtxqJKI/hbkV
DwqoVQYMtGidp2JRTm+OgS8D7hy3Hcf/1wSReqHnKLA3KZQLQ4oF5qo/vJ6L
Hyc0drdZPuKtWKMc/TsnSJy9HmpWSyT+At5p/jM=\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.109452, -5.45017, \
0.00604801, 0.439235}}],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
   False,
   Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"exps", "=", " ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "ka"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}], "]"}], " ", "/.", " ", "ysub"}]}], 
  TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "1.71446053664826987`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2.76239333806161857`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "3.79889607350388347`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "4.82630443554189803`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "5.84736219384075628`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "6.8639620913089816`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "7.87735197960939981`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "8.88836683387291159`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "9.89758030626200913`"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}]]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"exps", " ", "/.", " ", 
   RowBox[{"x", "\[Rule]", "1."}]}], TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
   "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
    "1.`", ",", "1.`", ",", "1.`"}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", "exps", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "10"}], "}"}]}], "]"}], 
  TraditionalForm]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 2363.97 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13291 -42 -4.5 ]
[.01131 .13291 0 4.5 ]
[.01131 .25111 -36 -4.5 ]
[.01131 .25111 0 4.5 ]
[.01131 .36931 -42 -4.5 ]
[.01131 .36931 0 4.5 ]
[.01131 .48751 -36 -4.5 ]
[.01131 .48751 0 4.5 ]
[.01131 .60571 -42 -4.5 ]
[.01131 .60571 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13291 m
.03006 .13291 L
s
[(0.00005)] .01131 .13291 1 0 Mshowa
.02381 .25111 m
.03006 .25111 L
s
[(0.0001)] .01131 .25111 1 0 Mshowa
.02381 .36931 m
.03006 .36931 L
s
[(0.00015)] .01131 .36931 1 0 Mshowa
.02381 .48751 m
.03006 .48751 L
s
[(0.0002)] .01131 .48751 1 0 Mshowa
.02381 .60571 m
.03006 .60571 L
s
[(0.00025)] .01131 .60571 1 0 Mshowa
.125 Mabswid
.02381 .03835 m
.02756 .03835 L
s
.02381 .06199 m
.02756 .06199 L
s
.02381 .08563 m
.02756 .08563 L
s
.02381 .10927 m
.02756 .10927 L
s
.02381 .15655 m
.02756 .15655 L
s
.02381 .18019 m
.02756 .18019 L
s
.02381 .20383 m
.02756 .20383 L
s
.02381 .22747 m
.02756 .22747 L
s
.02381 .27475 m
.02756 .27475 L
s
.02381 .29839 m
.02756 .29839 L
s
.02381 .32203 m
.02756 .32203 L
s
.02381 .34567 m
.02756 .34567 L
s
.02381 .39295 m
.02756 .39295 L
s
.02381 .41659 m
.02756 .41659 L
s
.02381 .44023 m
.02756 .44023 L
s
.02381 .46387 m
.02756 .46387 L
s
.02381 .51115 m
.02756 .51115 L
s
.02381 .53479 m
.02756 .53479 L
s
.02381 .55843 m
.02756 .55843 L
s
.02381 .58207 m
.02756 .58207 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.57923 .61803 m
.58558 .54716 L
.60389 .3976 L
.62059 .29818 L
.63777 .22279 L
.65646 .16336 L
.67425 .12261 L
.69316 .09148 L
.71068 .07071 L
.72713 .05636 L
.7453 .04474 L
.76195 .03697 L
.77898 .03109 L
.79761 .02642 L
.81526 .02324 L
.83412 .02078 L
.85333 .01901 L
.87147 .01781 L
.88948 .01696 L
.90609 .01638 L
.92297 .01594 L
.94155 .01559 L
.95825 .01536 L
.97619 .01519 L
s
.40442 .61803 m
.41147 .50451 L
.42057 .39098 L
.42915 .30806 L
.43702 .2482 L
.44584 .19548 L
.45405 .15718 L
.46306 .12443 L
.47268 .09771 L
.4819 .07824 L
.49189 .06225 L
.50133 .05087 L
.51003 .04281 L
.51875 .03653 L
.52691 .03193 L
.53587 .02799 L
.54549 .02476 L
.55461 .02242 L
.56455 .02049 L
.57393 .01912 L
.58264 .01813 L
.59217 .01731 L
.60114 .01671 L
.6092 .0163 L
.6179 .01594 L
.62648 .01567 L
.63588 .01544 L
.6457 .01526 L
.65485 .01514 L
.66428 .01504 L
.6732 .01496 L
.68121 .01491 L
.68992 .01487 L
.6984 .01483 L
.70775 .01481 L
.71751 .01478 L
.72667 .01477 L
.73554 .01476 L
.74487 .01475 L
.75283 .01474 L
.76153 .01473 L
.7708 .01473 L
.77922 .01473 L
.78893 .01472 L
.79808 .01472 L
.80686 .01472 L
.81613 .01472 L
.82405 .01472 L
.83275 .01472 L
.84192 .01472 L
Mistroke
.85029 .01472 L
.85995 .01472 L
.8691 .01472 L
.87778 .01472 L
.887 .01472 L
.89487 .01472 L
.90357 .01472 L
.91264 .01472 L
.92096 .01472 L
.9301 .01472 L
.93973 .01472 L
.9483 .01472 L
.95747 .01472 L
.96612 .01472 L
.97399 .01472 L
.97619 .01472 L
Mfstroke
.32675 .61803 m
.33189 .50062 L
.34074 .35612 L
.34519 .3006 L
.35005 .25016 L
.35868 .1816 L
.36671 .13588 L
.37125 .11579 L
.37618 .09776 L
.38052 .08455 L
.38512 .07285 L
.39382 .0558 L
.40185 .04454 L
.41034 .03597 L
.41502 .03235 L
.41946 .02949 L
.42808 .02519 L
.43595 .02237 L
.4446 .02014 L
.44943 .01919 L
.45381 .01847 L
.46234 .01739 L
.47037 .01665 L
.47918 .01608 L
.48361 .01586 L
.48847 .01566 L
.49708 .01538 L
.50511 .0152 L
.50963 .01512 L
.51454 .01505 L
.51887 .015 L
.52346 .01495 L
.53215 .01488 L
.54017 .01483 L
.54863 .0148 L
.55307 .01479 L
.55773 .01477 L
.56633 .01476 L
.5742 .01475 L
.58281 .01474 L
.58763 .01473 L
.592 .01473 L
.60051 .01473 L
.60854 .01472 L
.61731 .01472 L
.62173 .01472 L
.62659 .01472 L
.63518 .01472 L
.64321 .01472 L
.6477 .01472 L
Mistroke
.6526 .01472 L
.6615 .01472 L
.67017 .01472 L
.6782 .01472 L
.68685 .01472 L
.69497 .01472 L
.70389 .01472 L
.7089 .01472 L
.71351 .01472 L
.72232 .01472 L
.73052 .01472 L
.73952 .01472 L
.74456 .01472 L
.74914 .01472 L
.75811 .01472 L
.76638 .01472 L
.77547 .01472 L
.78005 .01472 L
.78509 .01472 L
.79423 .01472 L
.80258 .01472 L
.80718 .01472 L
.81221 .01472 L
.82137 .01472 L
.82616 .01472 L
.83067 .01472 L
.83909 .01472 L
.84816 .01472 L
.85327 .01472 L
.85797 .01472 L
.86674 .01472 L
.87492 .01472 L
.8839 .01472 L
.88894 .01472 L
.89353 .01472 L
.90246 .01472 L
.91072 .01472 L
.91978 .01472 L
.92436 .01472 L
.92941 .01472 L
.9385 .01472 L
.94683 .01472 L
.95598 .01472 L
.96058 .01472 L
.96561 .01472 L
.97619 .01472 L
Mfstroke
.28243 .61803 m
.2853 .53326 L
.2896 .43172 L
.29428 .34365 L
.2994 .26846 L
.30368 .219 L
.30825 .17677 L
.31307 .14161 L
.31756 .11579 L
.32205 .09522 L
.32629 .07967 L
.33422 .05818 L
.33838 .0499 L
.34297 .04261 L
.34743 .03696 L
.35223 .03216 L
.35671 .02861 L
.36081 .02601 L
.36884 .02223 L
.37314 .02076 L
.37772 .01951 L
.38596 .01787 L
.39101 .01716 L
.39575 .01664 L
.39998 .01627 L
.40462 .01594 L
.41343 .0155 L
.41824 .01533 L
.42273 .01521 L
.43076 .01504 L
.43527 .01497 L
.43936 .01493 L
.44371 .01488 L
.44831 .01485 L
.45658 .0148 L
.46117 .01478 L
.46547 .01477 L
.47015 .01476 L
.47527 .01475 L
.47957 .01474 L
.48414 .01474 L
.48898 .01473 L
.49347 .01473 L
.49797 .01473 L
.50221 .01472 L
.51014 .01472 L
.51432 .01472 L
.51891 .01472 L
.52339 .01472 L
.52819 .01472 L
Mistroke
.53268 .01472 L
.53678 .01472 L
.5448 .01472 L
.54912 .01472 L
.55371 .01472 L
.56196 .01472 L
.56654 .01472 L
.57083 .01472 L
.57551 .01472 L
.58064 .01472 L
.58491 .01472 L
.58947 .01472 L
.59429 .01472 L
.59878 .01472 L
.60326 .01472 L
.6075 .01472 L
.61543 .01472 L
.61958 .01472 L
.62416 .01472 L
.62862 .01472 L
.63342 .01472 L
.63789 .01472 L
.64199 .01472 L
.65002 .01472 L
.65431 .01472 L
.65889 .01472 L
.66712 .01472 L
.67216 .01472 L
.6769 .01472 L
.68113 .01472 L
.68577 .01472 L
.69457 .01472 L
.69937 .01472 L
.70386 .01472 L
.71188 .01472 L
.71638 .01472 L
.72049 .01472 L
.72482 .01472 L
.72942 .01472 L
.73768 .01472 L
.74226 .01472 L
.74656 .01472 L
.75124 .01472 L
.75636 .01472 L
.76065 .01472 L
.76522 .01472 L
.77005 .01472 L
.77454 .01472 L
.77903 .01472 L
.78327 .01472 L
Mistroke
.7912 .01472 L
.79537 .01472 L
.79996 .01472 L
.80443 .01472 L
.80923 .01472 L
.81371 .01472 L
.81781 .01472 L
.82584 .01472 L
.83015 .01472 L
.83473 .01472 L
.84297 .01472 L
.84802 .01472 L
.85277 .01472 L
.857 .01472 L
.86164 .01472 L
.87046 .01472 L
.87528 .01472 L
.87976 .01472 L
.8878 .01472 L
.8923 .01472 L
.8964 .01472 L
.90075 .01472 L
.90536 .01472 L
.91363 .01472 L
.91822 .01472 L
.92252 .01472 L
.92721 .01472 L
.93233 .01472 L
.93717 .01472 L
.94166 .01472 L
.94632 .01472 L
.95054 .01472 L
.95861 .01472 L
.96304 .01472 L
.96721 .01472 L
.97619 .01472 L
Mfstroke
.25393 .61803 m
.25586 .54633 L
.26029 .41977 L
.26469 .32389 L
.26872 .25606 L
.27315 .19861 L
.27781 .15283 L
.28188 .12229 L
.28567 .09997 L
.28983 .08077 L
.29426 .06501 L
.29906 .05218 L
.30348 .04328 L
.30834 .03592 L
.31348 .03018 L
.31794 .02647 L
.32211 .02381 L
.32669 .02158 L
.33161 .01979 L
.33634 .01851 L
.34073 .01762 L
.34554 .01687 L
.35067 .01629 L
.35556 .01588 L
.36016 .01559 L
.3643 .0154 L
.36876 .01523 L
.3732 .01511 L
.37734 .01502 L
.38188 .01495 L
.38674 .01489 L
.39184 .01484 L
.39667 .01481 L
.401 .01479 L
.40571 .01477 L
.41009 .01476 L
.41419 .01475 L
.4187 .01474 L
.42354 .01473 L
.42836 .01473 L
.43342 .01472 L
.43774 .01472 L
.44246 .01472 L
.44723 .01472 L
.45173 .01472 L
.45577 .01472 L
.46015 .01472 L
.46492 .01472 L
.46997 .01472 L
.47428 .01472 L
Mistroke
.47901 .01472 L
.48372 .01472 L
.48818 .01472 L
.49219 .01472 L
.49655 .01472 L
.50129 .01472 L
.50632 .01472 L
.51062 .01472 L
.51537 .01472 L
.51978 .01472 L
.52444 .01472 L
.52841 .01472 L
.53276 .01472 L
.53745 .01472 L
.54247 .01472 L
.54721 .01472 L
.55152 .01472 L
.55588 .01472 L
.56049 .01472 L
.56443 .01472 L
.56877 .01472 L
.57342 .01472 L
.57843 .01472 L
.58315 .01472 L
.58748 .01472 L
.59177 .01472 L
.59635 .01472 L
.60066 .01472 L
.60458 .01472 L
.60919 .01472 L
.61418 .01472 L
.6189 .01472 L
.62323 .01472 L
.62747 .01472 L
.632 .01472 L
.63628 .01472 L
.64019 .01472 L
.64476 .01472 L
.64974 .01472 L
.65444 .01472 L
.65879 .01472 L
.66296 .01472 L
.66746 .01472 L
.67171 .01472 L
.6756 .01472 L
.67992 .01472 L
.68464 .01472 L
.68956 .01472 L
.69415 .01472 L
.6987 .01472 L
Mistroke
.70363 .01472 L
.70828 .01472 L
.71257 .01472 L
.71644 .01472 L
.7207 .01472 L
.72515 .01472 L
.7293 .01472 L
.73379 .01472 L
.73868 .01472 L
.7433 .01472 L
.74758 .01472 L
.75182 .01472 L
.75566 .01472 L
.76009 .01472 L
.76426 .01472 L
.76847 .01472 L
.77308 .01472 L
.7779 .01472 L
.78238 .01472 L
.78659 .01472 L
.79042 .01472 L
.79484 .01472 L
.79902 .01472 L
.80317 .01472 L
.80774 .01472 L
.81252 .01472 L
.81699 .01472 L
.82117 .01472 L
.82499 .01472 L
.82939 .01472 L
.83359 .01472 L
.83811 .01472 L
.84221 .01472 L
.84694 .01472 L
.8514 .01472 L
.85554 .01472 L
.85935 .01472 L
.86353 .01472 L
.86795 .01472 L
.87241 .01472 L
.87647 .01472 L
.88117 .01472 L
.88561 .01472 L
.88972 .01472 L
.89351 .01472 L
.89768 .01472 L
.90211 .01472 L
.90651 .01472 L
.91054 .01472 L
.91497 .01472 L
Mistroke
.91963 .01472 L
.9237 .01472 L
.92748 .01472 L
.93164 .01472 L
.93608 .01472 L
.94087 .01472 L
.94529 .01472 L
.95014 .01472 L
.95528 .01472 L
.95974 .01472 L
.96391 .01472 L
.96849 .01472 L
.97341 .01472 L
.97619 .01472 L
Mfstroke
.23406 .61803 m
.23636 .51777 L
.24099 .37508 L
.24527 .27939 L
.24912 .21527 L
.25337 .16237 L
.25781 .12195 L
.26198 .09414 L
.2662 .07329 L
.27082 .05669 L
.27565 .04436 L
.28014 .03616 L
.28436 .03054 L
.28819 .02672 L
.29262 .02344 L
.29679 .02117 L
.30096 .0195 L
.30554 .01815 L
.31033 .01715 L
.31481 .01648 L
.31899 .01602 L
.32281 .01571 L
.32722 .01544 L
.33141 .01525 L
.33595 .0151 L
.34006 .015 L
.34481 .01492 L
.34927 .01486 L
.35342 .01482 L
.35723 .0148 L
.36142 .01478 L
.36583 .01476 L
.37031 .01475 L
.37439 .01474 L
.37909 .01473 L
.38354 .01473 L
.38766 .01472 L
.39146 .01472 L
.39563 .01472 L
.40006 .01472 L
.40447 .01472 L
.40851 .01472 L
.41295 .01472 L
.41762 .01472 L
.42169 .01472 L
.42548 .01472 L
.42964 .01472 L
.43408 .01472 L
.43889 .01472 L
.44332 .01472 L
Mistroke
.44818 .01472 L
.45063 .01472 L
.45333 .01472 L
.45785 .01472 L
.46271 .01472 L
.46729 .01472 L
.47147 .01472 L
.47579 .01472 L
.48038 .01472 L
.4843 .01472 L
.48863 .01472 L
.49326 .01472 L
.49826 .01472 L
.50298 .01472 L
.5073 .01472 L
.51156 .01472 L
.51611 .01472 L
.52041 .01472 L
.52432 .01472 L
.52891 .01472 L
.53389 .01472 L
.5386 .01472 L
.54294 .01472 L
.54714 .01472 L
.55165 .01472 L
.55591 .01472 L
.5598 .01472 L
.56436 .01472 L
.56932 .01472 L
.57402 .01472 L
.57837 .01472 L
.58295 .01472 L
.58789 .01472 L
.59256 .01472 L
.59686 .01472 L
.60074 .01472 L
.605 .01472 L
.60945 .01472 L
.61361 .01472 L
.61812 .01472 L
.62302 .01472 L
.62765 .01472 L
.63194 .01472 L
.63579 .01472 L
.64004 .01472 L
.64448 .01472 L
.64864 .01472 L
.65287 .01472 L
.6575 .01472 L
.66233 .01472 L
Mistroke
.66682 .01472 L
.67104 .01472 L
.67488 .01472 L
.6793 .01472 L
.68348 .01472 L
.68765 .01472 L
.69224 .01472 L
.69703 .01472 L
.7015 .01472 L
.70569 .01472 L
.70951 .01472 L
.71393 .01472 L
.71812 .01472 L
.72266 .01472 L
.72678 .01472 L
.73152 .01472 L
.73599 .01472 L
.74014 .01472 L
.74395 .01472 L
.74814 .01472 L
.75255 .01472 L
.75704 .01472 L
.76112 .01472 L
.76583 .01472 L
.77028 .01472 L
.77439 .01472 L
.7782 .01472 L
.78237 .01472 L
.78679 .01472 L
.79121 .01472 L
.79526 .01472 L
.79993 .01472 L
.80437 .01472 L
.80845 .01472 L
.81224 .01472 L
.8164 .01472 L
.82083 .01472 L
.82565 .01472 L
.83009 .01472 L
.83495 .01472 L
.8374 .01472 L
.8401 .01472 L
.84463 .01472 L
.84948 .01472 L
.85407 .01472 L
.85825 .01472 L
.86257 .01472 L
.86716 .01472 L
.87109 .01472 L
.87542 .01472 L
Mistroke
.88005 .01472 L
.88505 .01472 L
.88977 .01472 L
.8941 .01472 L
.89836 .01472 L
.90291 .01472 L
.90721 .01472 L
.91112 .01472 L
.91572 .01472 L
.9207 .01472 L
.92541 .01472 L
.92975 .01472 L
.93395 .01472 L
.93847 .01472 L
.94273 .01472 L
.94663 .01472 L
.95118 .01472 L
.95615 .01472 L
.96085 .01472 L
.9652 .01472 L
.96817 .01472 L
.97097 .01472 L
.97619 .01472 L
Mfstroke
.21925 .61803 m
.22142 .51145 L
.22377 .42394 L
.22592 .35732 L
.23018 .25546 L
.23257 .21232 L
.23474 .17986 L
.23896 .13118 L
.24295 .09847 L
.24521 .08419 L
.2476 .07172 L
.25189 .0547 L
.25427 .04754 L
.2565 .04201 L
.25914 .03667 L
.26158 .03265 L
.26606 .0271 L
.26842 .0249 L
.27094 .02298 L
.27335 .02149 L
.27561 .02033 L
.27984 .01868 L
.28402 .01752 L
.28786 .01676 L
.29207 .01616 L
.29419 .01592 L
.29652 .01571 L
.29879 .01554 L
.30125 .01539 L
.30342 .01528 L
.30573 .01518 L
.31009 .01504 L
.31411 .01495 L
.31634 .01491 L
.31874 .01487 L
.32307 .01483 L
.32558 .01481 L
.32823 .01479 L
.33066 .01477 L
.33295 .01476 L
.33512 .01476 L
.33746 .01475 L
.34156 .01474 L
.34389 .01473 L
.34635 .01473 L
.34847 .01473 L
.35075 .01473 L
.35483 .01472 L
.35863 .01472 L
.36096 .01472 L
Mistroke
.36316 .01472 L
.36729 .01472 L
.37141 .01472 L
.37376 .01472 L
.37597 .01472 L
.3804 .01472 L
.3829 .01472 L
.38519 .01472 L
.38904 .01472 L
.39326 .01472 L
.39539 .01472 L
.39766 .01472 L
.40176 .01472 L
.40408 .01472 L
.40655 .01472 L
.41096 .01472 L
.41342 .01472 L
.41572 .01472 L
.4184 .01472 L
.42095 .01472 L
.42313 .01472 L
.42551 .01472 L
.42969 .01472 L
.43204 .01472 L
.43456 .01472 L
.43908 .01472 L
.44143 .01472 L
.44391 .01472 L
.44834 .01472 L
.45082 .01472 L
.45312 .01472 L
.45581 .01472 L
.45836 .01472 L
.46056 .01472 L
.46295 .01472 L
.46713 .01472 L
.4695 .01472 L
.47201 .01472 L
.47421 .01472 L
.47652 .01472 L
.48093 .01472 L
.48496 .01472 L
.48931 .01472 L
.49177 .01472 L
.49406 .01472 L
.49823 .01472 L
.50202 .01472 L
.50411 .01472 L
.50639 .01472 L
.51051 .01472 L
Mistroke
.51264 .01472 L
.51492 .01472 L
.51904 .01472 L
.52156 .01472 L
.52394 .01472 L
.52842 .01472 L
.5307 .01472 L
.53312 .01472 L
.53748 .01472 L
.54015 .01472 L
.54267 .01472 L
.5451 .01472 L
.54736 .01472 L
.55157 .01472 L
.55379 .01472 L
.55618 .01472 L
.55868 .01472 L
.56105 .01472 L
.5632 .01472 L
.56548 .01472 L
.56963 .01472 L
.57346 .01472 L
.57758 .01472 L
.57992 .01472 L
.58212 .01472 L
.58658 .01472 L
.58911 .01472 L
.59146 .01472 L
.59575 .01472 L
.59815 .01472 L
.60033 .01472 L
.60446 .01472 L
.60678 .01472 L
.60892 .01472 L
.61285 .01472 L
.617 .01472 L
.61929 .01472 L
.62146 .01472 L
.62553 .01472 L
.62991 .01472 L
.63238 .01472 L
.63467 .01472 L
.63847 .01472 L
.64267 .01472 L
.64478 .01472 L
.64705 .01472 L
.65117 .01472 L
.65332 .01472 L
.65563 .01472 L
.65978 .01472 L
Mistroke
.66231 .01472 L
.66471 .01472 L
.66919 .01472 L
.6715 .01472 L
.67393 .01472 L
.6783 .01472 L
.68073 .01472 L
.68301 .01472 L
.68569 .01472 L
.68818 .01472 L
.69266 .01472 L
.69502 .01472 L
.69754 .01472 L
.69995 .01472 L
.70221 .01472 L
.70643 .01472 L
.71061 .01472 L
.71445 .01472 L
.71866 .01472 L
.72079 .01472 L
.72311 .01472 L
.72538 .01472 L
.72784 .01472 L
.73001 .01472 L
.73231 .01472 L
.73667 .01472 L
.7407 .01472 L
.74292 .01472 L
.74532 .01472 L
.74965 .01472 L
.75217 .01472 L
.75481 .01472 L
.75724 .01472 L
.75953 .01472 L
.7617 .01472 L
.76404 .01472 L
.76814 .01472 L
.77046 .01472 L
.77292 .01472 L
.77504 .01472 L
.77732 .01472 L
.7814 .01472 L
.7852 .01472 L
.78753 .01472 L
.78973 .01472 L
.79386 .01472 L
.79798 .01472 L
.80033 .01472 L
.80253 .01472 L
.80697 .01472 L
Mistroke
.80946 .01472 L
.81175 .01472 L
.8156 .01472 L
.81982 .01472 L
.82194 .01472 L
.82422 .01472 L
.82832 .01472 L
.83064 .01472 L
.8331 .01472 L
.83752 .01472 L
.83997 .01472 L
.84227 .01472 L
.84495 .01472 L
.8475 .01472 L
.84968 .01472 L
.85206 .01472 L
.85623 .01472 L
.85859 .01472 L
.86111 .01472 L
.86563 .01472 L
.86797 .01472 L
.87045 .01472 L
.87489 .01472 L
.87736 .01472 L
.87966 .01472 L
.88235 .01472 L
.8849 .01472 L
.8871 .01472 L
.88949 .01472 L
.89367 .01472 L
.89603 .01472 L
.89855 .01472 L
.90074 .01472 L
.90306 .01472 L
.90746 .01472 L
.91149 .01472 L
.91584 .01472 L
.9183 .01472 L
.92059 .01472 L
.92476 .01472 L
.92854 .01472 L
.93064 .01472 L
.93291 .01472 L
.93704 .01472 L
.93916 .01472 L
.94144 .01472 L
.94556 .01472 L
.94808 .01472 L
.95046 .01472 L
.95493 .01472 L
Mistroke
.95721 .01472 L
.95964 .01472 L
.964 .01472 L
.96667 .01472 L
.96918 .01472 L
.97387 .01472 L
.97619 .01472 L
Mfstroke
.2077 .61803 m
.21006 .49871 L
.2142 .34343 L
.21653 .27916 L
.21867 .23134 L
.22261 .1647 L
.22459 .13938 L
.22676 .11656 L
.22904 .09702 L
.23152 .08005 L
.2337 .06801 L
.23601 .05768 L
.23809 .05009 L
.24038 .04329 L
.24441 .03433 L
.24686 .03031 L
.2491 .02737 L
.25152 .02482 L
.25415 .02262 L
.25658 .02102 L
.25882 .01982 L
.26326 .01809 L
.26565 .01742 L
.26785 .01692 L
.27021 .01648 L
.2728 .0161 L
.27716 .01564 L
.27955 .01545 L
.28177 .01532 L
.28395 .0152 L
.28601 .01512 L
.28986 .015 L
.29202 .01495 L
.29402 .01491 L
.29637 .01487 L
.29853 .01484 L
.30271 .0148 L
.30491 .01478 L
.30721 .01477 L
.31111 .01475 L
.31331 .01475 L
.31536 .01474 L
.31778 .01474 L
.32007 .01473 L
.32434 .01473 L
.32673 .01472 L
.32894 .01472 L
.33154 .01472 L
.33391 .01472 L
.33813 .01472 L
Mistroke
.34046 .01472 L
.34266 .01472 L
.34657 .01472 L
.34879 .01472 L
.35083 .01472 L
.35512 .01472 L
.35755 .01472 L
.35984 .01472 L
.36445 .01472 L
.36704 .01472 L
.36942 .01472 L
.37368 .01472 L
.37606 .01472 L
.37823 .01472 L
.38025 .01472 L
.38245 .01472 L
.38643 .01472 L
.38867 .01472 L
.39114 .01472 L
.39354 .01472 L
.39612 .01472 L
.39853 .01472 L
.40073 .01472 L
.403 .01472 L
.40506 .01472 L
.40935 .01472 L
.41171 .01472 L
.41393 .01472 L
.41788 .01472 L
.42011 .01472 L
.42216 .01472 L
.42648 .01472 L
.42894 .01472 L
.43123 .01472 L
.43586 .01472 L
.43845 .01472 L
.44081 .01472 L
.44514 .01472 L
.44733 .01472 L
.44974 .01472 L
.45179 .01472 L
.454 .01472 L
.458 .01472 L
.46027 .01472 L
.46275 .01472 L
.46517 .01472 L
.46775 .01472 L
.47018 .01472 L
.47238 .01472 L
.47669 .01472 L
Mistroke
.47877 .01472 L
.48106 .01472 L
.48329 .01472 L
.48568 .01472 L
.48792 .01472 L
.48997 .01472 L
.49397 .01472 L
.49636 .01472 L
.49857 .01472 L
.5012 .01472 L
.50358 .01472 L
.50799 .01472 L
.51042 .01472 L
.51269 .01472 L
.5169 .01472 L
.51929 .01472 L
.52151 .01472 L
.526 .01472 L
.52852 .01472 L
.53081 .01472 L
.53491 .01472 L
.53723 .01472 L
.53937 .01472 L
.54329 .01472 L
.54527 .01472 L
.54745 .01472 L
.54969 .01472 L
.55213 .01472 L
.55428 .01472 L
.55657 .01472 L
.55884 .01472 L
.5609 .01472 L
.56491 .01472 L
.56733 .01472 L
.56956 .01472 L
.57195 .01472 L
.57459 .01472 L
.57902 .01472 L
.58144 .01472 L
.5837 .01472 L
.5882 .01472 L
.59075 .01472 L
.5931 .01472 L
.59742 .01472 L
.5996 .01472 L
.60201 .01472 L
.60615 .01472 L
.60848 .01472 L
.61062 .01472 L
.61456 .01472 L
Mistroke
.61654 .01472 L
.61871 .01472 L
.62099 .01472 L
.62346 .01472 L
.62564 .01472 L
.62795 .01472 L
.63003 .01472 L
.63232 .01472 L
.63635 .01472 L
.6388 .01472 L
.64104 .01472 L
.64346 .01472 L
.64609 .01472 L
.64851 .01472 L
.65076 .01472 L
.6552 .01472 L
.65759 .01472 L
.65978 .01472 L
.66214 .01472 L
.66473 .01472 L
.66909 .01472 L
.67148 .01472 L
.6737 .01472 L
.67587 .01472 L
.67793 .01472 L
.68179 .01472 L
.68395 .01472 L
.68594 .01472 L
.6883 .01472 L
.69045 .01472 L
.69463 .01472 L
.69683 .01472 L
.69914 .01472 L
.70303 .01472 L
.70523 .01472 L
.70728 .01472 L
.7097 .01472 L
.71198 .01472 L
.71625 .01472 L
.71865 .01472 L
.72085 .01472 L
.72345 .01472 L
.72583 .01472 L
.73005 .01472 L
.73237 .01472 L
.73457 .01472 L
.73848 .01472 L
.74069 .01472 L
.74274 .01472 L
.74702 .01472 L
Mistroke
.74946 .01472 L
.75175 .01472 L
.75636 .01472 L
.75895 .01472 L
.76133 .01472 L
.76558 .01472 L
.76796 .01472 L
.77013 .01472 L
.77215 .01472 L
.77435 .01472 L
.77833 .01472 L
.78057 .01472 L
.78303 .01472 L
.78543 .01472 L
.78801 .01472 L
.79042 .01472 L
.79263 .01472 L
.79489 .01472 L
.79695 .01472 L
.80124 .01472 L
.8036 .01472 L
.80581 .01472 L
.80977 .01472 L
.81199 .01472 L
.81404 .01472 L
.81837 .01472 L
.82082 .01472 L
.82311 .01472 L
.82774 .01472 L
.83033 .01472 L
.83269 .01472 L
.83702 .01472 L
.83921 .01472 L
.84162 .01472 L
.84367 .01472 L
.84588 .01472 L
.84988 .01472 L
.85214 .01472 L
.85463 .01472 L
.85704 .01472 L
.85962 .01472 L
.86205 .01472 L
.86425 .01472 L
.86856 .01472 L
.87064 .01472 L
.87293 .01472 L
.87516 .01472 L
.87755 .01472 L
.87979 .01472 L
.88183 .01472 L
Mistroke
.88583 .01472 L
.88822 .01472 L
.89043 .01472 L
.89306 .01472 L
.89544 .01472 L
.89985 .01472 L
.90227 .01472 L
.90455 .01472 L
.90876 .01472 L
.91114 .01472 L
.91337 .01472 L
.91786 .01472 L
.92037 .01472 L
.92266 .01472 L
.92676 .01472 L
.92908 .01472 L
.93121 .01472 L
.93514 .01472 L
.93712 .01472 L
.9393 .01472 L
.94153 .01472 L
.94397 .01472 L
.94612 .01472 L
.94841 .01472 L
.95068 .01472 L
.95274 .01472 L
.95675 .01472 L
.95917 .01472 L
.9614 .01472 L
.96379 .01472 L
.96642 .01472 L
.97085 .01472 L
.97328 .01472 L
.97554 .01472 L
.97619 .01472 L
Mfstroke
.1987 .61803 m
.20066 .50453 L
.20271 .41059 L
.20492 .3294 L
.20892 .22243 L
.21119 .17882 L
.21367 .14153 L
.21626 .11161 L
.21866 .09014 L
.22089 .07459 L
.22299 .06286 L
.2254 .05216 L
.2276 .04451 L
.23177 .03404 L
.23414 .02983 L
.23635 .02672 L
.23864 .02418 L
.24082 .02226 L
.24332 .02053 L
.24561 .0193 L
.24761 .01844 L
.24974 .0177 L
.25356 .01672 L
.2559 .01629 L
.25811 .01597 L
.26222 .01553 L
.2644 .01537 L
.26642 .01524 L
.26884 .01513 L
.27103 .01504 L
.27318 .01498 L
.27552 .01492 L
.27799 .01487 L
.28033 .01484 L
.28452 .0148 L
.28664 .01478 L
.28897 .01477 L
.29096 .01476 L
.2931 .01475 L
.29696 .01474 L
.29913 .01473 L
.30144 .01473 L
.30344 .01473 L
.3056 .01472 L
.30815 .01472 L
.31055 .01472 L
.31288 .01472 L
.31504 .01472 L
.31716 .01472 L
.31944 .01472 L
Mistroke
.32194 .01472 L
.32427 .01472 L
.32689 .01472 L
.32938 .01472 L
.33161 .01472 L
.33404 .01472 L
.33613 .01472 L
.33839 .01472 L
.34248 .01472 L
.34485 .01472 L
.34735 .01472 L
.34948 .01472 L
.35181 .01472 L
.35429 .01472 L
.35654 .01472 L
.35914 .01472 L
.3616 .01472 L
.36372 .01472 L
.36597 .01472 L
.36844 .01472 L
.37071 .01472 L
.37298 .01472 L
.37514 .01472 L
.37919 .01472 L
.38145 .01472 L
.38355 .01472 L
.386 .01472 L
.38831 .01472 L
.39032 .01472 L
.39249 .01472 L
.39628 .01472 L
.39844 .01472 L
.40071 .01472 L
.40478 .01472 L
.40708 .01472 L
.40925 .01472 L
.41332 .01472 L
.4156 .01472 L
.4177 .01472 L
.42016 .01472 L
.42247 .01472 L
.42627 .01472 L
.4283 .01472 L
.43047 .01472 L
.43263 .01472 L
.43491 .01472 L
.43897 .01472 L
.44129 .01472 L
.44348 .01472 L
.44757 .01472 L
Mistroke
.44987 .01472 L
.45198 .01472 L
.45445 .01472 L
.45675 .01472 L
.46058 .01472 L
.46261 .01472 L
.46479 .01472 L
.46707 .01472 L
.46923 .01472 L
.47329 .01472 L
.47563 .01472 L
.47783 .01472 L
.48195 .01472 L
.48426 .01472 L
.48638 .01472 L
.48886 .01472 L
.49116 .01472 L
.49501 .01472 L
.49705 .01472 L
.49923 .01472 L
.50151 .01472 L
.50368 .01472 L
.50773 .01472 L
.50987 .01472 L
.51188 .01472 L
.51426 .01472 L
.51645 .01472 L
.51858 .01472 L
.5209 .01472 L
.52336 .01472 L
.5257 .01472 L
.52986 .01472 L
.53219 .01472 L
.5343 .01472 L
.53628 .01472 L
.53841 .01472 L
.54229 .01472 L
.54442 .01472 L
.54671 .01472 L
.55084 .01472 L
.55336 .01472 L
.55575 .01472 L
.55788 .01472 L
.56023 .01472 L
.56251 .01472 L
.56494 .01472 L
.56722 .01472 L
.5693 .01472 L
.57175 .01472 L
.5744 .01472 L
Mistroke
.57673 .01472 L
.57918 .01472 L
.58149 .01472 L
.58368 .01472 L
.58777 .01472 L
.59006 .01472 L
.59217 .01472 L
.59463 .01472 L
.59694 .01472 L
.60076 .01472 L
.60279 .01472 L
.60497 .01472 L
.60724 .01472 L
.60941 .01472 L
.61347 .01472 L
.6158 .01472 L
.618 .01472 L
.62211 .01472 L
.62442 .01472 L
.62654 .01472 L
.62901 .01472 L
.63132 .01472 L
.63516 .01472 L
.6372 .01472 L
.63938 .01472 L
.64166 .01472 L
.64382 .01472 L
.64788 .01472 L
.65001 .01472 L
.65202 .01472 L
.6544 .01472 L
.65658 .01472 L
.65871 .01472 L
.66103 .01472 L
.66337 .01472 L
.66582 .01472 L
.66998 .01472 L
.67231 .01472 L
.67442 .01472 L
.67639 .01472 L
.67853 .01472 L
.68241 .01472 L
.68454 .01472 L
.68682 .01472 L
.69095 .01472 L
.69346 .01472 L
.69585 .01472 L
.69798 .01472 L
.70032 .01472 L
.70261 .01472 L
Mistroke
.70503 .01472 L
.70731 .01472 L
.70939 .01472 L
.71184 .01472 L
.71449 .01472 L
.71682 .01472 L
.71927 .01472 L
.72158 .01472 L
.72376 .01472 L
.72784 .01472 L
.73013 .01472 L
.73224 .01472 L
.7347 .01472 L
.73701 .01472 L
.74083 .01472 L
.74285 .01472 L
.74503 .01472 L
.74731 .01472 L
.74947 .01472 L
.75353 .01472 L
.75586 .01472 L
.75806 .01472 L
.76216 .01472 L
.76446 .01472 L
.76658 .01472 L
.76905 .01472 L
.77136 .01472 L
.7752 .01472 L
.77723 .01472 L
.77941 .01472 L
.78169 .01472 L
.78386 .01472 L
.78791 .01472 L
.79004 .01472 L
.79204 .01472 L
.79442 .01472 L
.7966 .01472 L
.79872 .01472 L
.80105 .01472 L
.80338 .01472 L
.80583 .01472 L
.80999 .01472 L
.81231 .01472 L
.81442 .01472 L
.8164 .01472 L
.81853 .01472 L
.82241 .01472 L
.82454 .01472 L
.82682 .01472 L
.83094 .01472 L
Mistroke
.83345 .01472 L
.83583 .01472 L
.83818 .01472 L
.84031 .01472 L
.84259 .01472 L
.84501 .01472 L
.84728 .01472 L
.84937 .01472 L
.85182 .01472 L
.85446 .01472 L
.85679 .01472 L
.85925 .01472 L
.86155 .01472 L
.86373 .01472 L
.8678 .01472 L
.87009 .01472 L
.87219 .01472 L
.87466 .01472 L
.87696 .01472 L
.88077 .01472 L
.8828 .01472 L
.88498 .01472 L
.88725 .01472 L
.88941 .01472 L
.89348 .01472 L
.8958 .01472 L
.89799 .01472 L
.90209 .01472 L
.90439 .01472 L
.90651 .01472 L
.90898 .01472 L
.91128 .01472 L
.91512 .01472 L
.91715 .01472 L
.91933 .01472 L
.92161 .01472 L
.92377 .01472 L
.92783 .01472 L
.92995 .01472 L
.93195 .01472 L
.93433 .01472 L
.9365 .01472 L
.93862 .01472 L
.94094 .01472 L
.94327 .01472 L
.94573 .01472 L
.94988 .01472 L
.9522 .01472 L
.95431 .01472 L
.95628 .01472 L
Mistroke
.95842 .01472 L
.96043 .01472 L
.9623 .01472 L
.96551 .01472 L
.96736 .01472 L
.96905 .01472 L
.97249 .01472 L
.97439 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztndly0zAUhh07baHADPtyV65YutCyD0OZYd/3fSeU9YKBKbwYb8Yd3JXI
cSRb/eUcRbIsJ8o0qTl2re/8OjqSZTnc7vz68vFb59fXlc7M1dXOjy9fV37O
XPm+2jUlrShqzURR9HsmYttr3c3sY637s7affTCLu+0X7FebIcynhiTq4aTH
RLPsM+Z7063D/C8SbktyJ5NOsQBs6SmidsHWfc2WmScK5mxXFLOtFttq9bbS
HS9VZU4MLMZC6a9A6YfwyefYRlLUd067wNfKAoVNnLl43Jwtr1H4KOp5TvKV
RHSIS5XgA2I1hwhjFI2z/MzlYLEc7qioPwN3HWC//nH58LEbgG2jga3N2buV
2q/I/osfLhp038Vsb+p6qngbxFX6r0lQ6iT/s01KH4v1qCrG1H+k5xT7nDYt
ra2uxKMwiPqhGqtKRrYpYNvC1drHttLGusxt82quJdyAklIqsRepsAXY9vJ2
tcz5ltRUiyVUiGVI1TZzP/bxrbNctZM5vlgAk6hiUyqkn2Q7zUnPqJU84kZJ
1KYR8yku5jkrzCY6azFLNrf0KJ9S6U9yxc8PyYx7fmWOJ0TzHhWnZBtILPc9
w0s8YRn9Qg49Vd8wLNBxVLl3E5kvquVecEOPgppKf0mbHpHabpKI/gSwXVbT
z2cBmrf1Q57qgu0KQC5cGeRCLeGzi0h/VZueSoqOQ/3RNFH748B2LUefu7gZ
OuSRH1RmpDhivm5FcRfxcgzYbgyiH65vMgkWKvpNd+gmqqNLplsjia6Y5nBB
v5NIfztHLyYB9YaMaIyFbCYq5zl1VLZPTFX2jjaxSRocD/odRPq7o0BfPoMk
zeQot9LjElXQO1ID9WooEpeA7V4GJeY0c6BwgpE7YGhGnohKUfdL9AtrVLHU
VtsQrWDAuVENtTek2v3aVIsJjZOulUmv1hCtCN7VrdoisD0YW9Womb9ENZFy
p/kWoc9T3mNSu7pOPZR9qF5SY+NhrzB5BF7ki0uqwjWktEtxT12X2CSpy5PG
7P3IKrHtJOE38XYi8eNaiKlxPHrEuWULXnPWqyw1ep8MSUwa+6IU1yhYtAKA
GguNhU0bmAeJAC1heqoWVbEGKxDrtrJATCOmtjcUFc8aTVx1hvBHWerdcSox
wnruDTFqb0jjQEwjRosxqXGcEW/g7U1//rt8BsCS3ybtF1VHb2l9dlt4HZ2V
WaJyJc0HZ6MkiU7QBHGKNvZSzKkFZapQBvUGSJmX1StTflPDTz1EX1M+x4yK
b06tyyNYL/mkXYqnqgxhqcMT9IzQqwDrO6ztUaq3sKiBIdjXOVjxhKe3iI3S
kwZb1cVFIK6HWO5B2ftNo4nL8oJPnM1TVofYasdLbWoB1gYsCoO3TYUdnA1q
R2yUngG2AliTJdJiirh8wqJe5+WJBPZ+lxVW4WpC6ncWiAowTxXUb2hoqkzW
44oq2DZio3ImWNFsr/GZjOu8EwkPXdEzg2Mpkkja1IdQvJWJusB5Ajce5W3O
eh1GKbnTK0weYE6uC5HsN/VJySo5oaiVEJuMCQJxIK6D2PagraoMYcIpf88e
e7/3WtmhiJM8pfb8mclgFAVCwA24EDeXFfyFbJimZNzKr0sDqX1S1BusqEkP
YipPYNPmX+/ciRd6UoeFAbYG2OqWLrtzmZrzMpcrX1FIuFTSE8dFJ+tAHOXX
uw6RKUdEEura3HrjBeWPD9WLQ/2mlrEUR8M7b/WhrmUuX9XsrXvmAwHXsB4k
4pHSM8AGWD+a1UFg++iDnluJegbYANtkWMc5wJqewsZeGg8ymFy9jxWpjel1
Ki7qBj4FXEe4uRzgL2TDNA24VFxql9BMXBcLrOt2HwXX56y0yr+wtVgsekxR
VIHLHOeRUNT1nepJzLGTTHeZ9ZjKhBbURniN9ZgqpJG7/vV2Uhczo37ib+8U
6fks/L/HUes/7mpVrA==\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.9117, -3.25721, 0.0423905, \
1.7078}}],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
   False,
   Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"strm", "=", 
  RowBox[{"OpenWrite", "[", "\"\<exps\>\"", "]"}]}]], "Input"],

Cell[BoxData[
 FormBox[
  RowBox[{"OutputStream", "[", 
   RowBox[{"\<\"exps\"\>", ",", "15"}], "]"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"k", "=", "1"}], ",", 
    RowBox[{"k", "<=", "10"}], ",", 
    RowBox[{"k", "+=", "0.1"}], ",", 
    RowBox[{"Write", "[", 
     RowBox[{"strm", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"exps", "/.", 
          RowBox[{"x", "\[Rule]", "k"}]}]}], "}"}], "]"}]}], "]"}]}], "]"}], 
  TraditionalForm]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Close", "[", "strm", "]"}], TraditionalForm]], "Input"],

Cell[BoxData[
 FormBox["\<\"exps\"\>", TraditionalForm]], "Output"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 404}, {Automatic, 155}},
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 67, 0, 85, "Subtitle"],
Cell[CellGroupData[{
Cell[659, 26, 762, 25, 135, "Input"],
Cell[1424, 53, 868, 22, 77, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2329, 80, 362, 13, 46, "Input"],
Cell[2694, 95, 7098, 366, 186, 4656, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[9795, 463, 166, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9998, 473, 394, 14, 46, "Input"],
Cell[10395, 489, 7111, 419, 186, 5542, 390, "GraphicsData", "PostScript", \
"Graphics"],
Cell[17509, 910, 166, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17712, 920, 263, 9, 32, "Input"],
Cell[17978, 931, 1630, 48, 55, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19645, 984, 123, 3, 32, "Input"],
Cell[19771, 989, 200, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20008, 999, 215, 7, 32, "Input"],
Cell[20226, 1008, 29503, 1798, 186, 27288, 1758, "GraphicsData", \
"PostScript", "Graphics"],
Cell[49732, 2808, 166, 5, 32, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49935, 2818, 99, 2, 32, "Input"],
Cell[50037, 2822, 131, 3, 32, "Output"]
}, Open  ]],
Cell[50183, 2828, 441, 14, 55, "Input"],
Cell[CellGroupData[{
Cell[50649, 2846, 90, 2, 32, "Input"],
Cell[50742, 2850, 67, 1, 32, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

