(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19218,        816]
NotebookOptionsPosition[     17332,        752]
NotebookOutlinePosition[     18003,        776]
CellTagsIndexPosition[     17960,        773]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Bound States in a Square Well", "Title"],

Cell["Niels Walet, 1998-2009", "Subsubtitle",
 CellChangeTimes->{{3.4688263353238277`*^9, 3.468826347215578*^9}}],

Cell[CellGroupData[{

Cell["Description", "Section"],

Cell[TextData[{
 "We investigate the bound states in a square well, of width ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]]],
 " and depth ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    SubscriptBox["V", "0"]}], TraditionalForm]]],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], ",", 
      RowBox[{"-", "1"}], ",", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"Hue", "[", "0.0", "]"}]}]}], "]"}], TraditionalForm]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.603319 0.588604 [
[.02381 .59082 -6 -9 ]
[.02381 .59082 6 0 ]
[.2619 .59082 -6 -9 ]
[.2619 .59082 6 0 ]
[.7381 .59082 -3 -9 ]
[.7381 .59082 3 0 ]
[.97619 .59082 -3 -9 ]
[.97619 .59082 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .13244 -24 -4.5 ]
[.4875 .13244 0 4.5 ]
[.4875 .25016 -24 -4.5 ]
[.4875 .25016 0 4.5 ]
[.4875 .36788 -24 -4.5 ]
[.4875 .36788 0 4.5 ]
[.4875 .4856 -24 -4.5 ]
[.4875 .4856 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .60332 m
.02381 .60957 L
s
[(-2)] .02381 .59082 0 1 Mshowa
.2619 .60332 m
.2619 .60957 L
s
[(-1)] .2619 .59082 0 1 Mshowa
.7381 .60332 m
.7381 .60957 L
s
[(1)] .7381 .59082 0 1 Mshowa
.97619 .60332 m
.97619 .60957 L
s
[(2)] .97619 .59082 0 1 Mshowa
.125 Mabswid
.07143 .60332 m
.07143 .60707 L
s
.11905 .60332 m
.11905 .60707 L
s
.16667 .60332 m
.16667 .60707 L
s
.21429 .60332 m
.21429 .60707 L
s
.30952 .60332 m
.30952 .60707 L
s
.35714 .60332 m
.35714 .60707 L
s
.40476 .60332 m
.40476 .60707 L
s
.45238 .60332 m
.45238 .60707 L
s
.54762 .60332 m
.54762 .60707 L
s
.59524 .60332 m
.59524 .60707 L
s
.64286 .60332 m
.64286 .60707 L
s
.69048 .60332 m
.69048 .60707 L
s
.78571 .60332 m
.78571 .60707 L
s
.83333 .60332 m
.83333 .60707 L
s
.88095 .60332 m
.88095 .60707 L
s
.92857 .60332 m
.92857 .60707 L
s
.25 Mabswid
0 .60332 m
1 .60332 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .13244 m
.50625 .13244 L
s
[(-0.8)] .4875 .13244 1 0 Mshowa
.5 .25016 m
.50625 .25016 L
s
[(-0.6)] .4875 .25016 1 0 Mshowa
.5 .36788 m
.50625 .36788 L
s
[(-0.4)] .4875 .36788 1 0 Mshowa
.5 .4856 m
.50625 .4856 L
s
[(-0.2)] .4875 .4856 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .16187 m
.50375 .16187 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .30902 m
.50375 .30902 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .45617 m
.50375 .45617 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .60332 m
.06244 .60332 L
.10458 .60332 L
.14415 .60332 L
.18221 .60332 L
.22272 .60332 L
.24141 .60332 L
.25127 .60332 L
.25666 .60332 L
.2593 .60332 L
.26045 .60332 L
.26171 .60332 L
.26301 .01472 L
.26425 .01472 L
.26698 .01472 L
.27279 .01472 L
.28302 .01472 L
.30316 .01472 L
.3438 .01472 L
.38293 .01472 L
.42451 .01472 L
.46458 .01472 L
.50313 .01472 L
.54413 .01472 L
.58362 .01472 L
.62159 .01472 L
.66202 .01472 L
.70093 .01472 L
.7111 .01472 L
.72217 .01472 L
.72723 .01472 L
.73262 .01472 L
.73483 .01472 L
.73599 .01472 L
.73721 .01472 L
.73786 .01472 L
.73858 .60332 L
.73983 .60332 L
.74229 .60332 L
.78285 .60332 L
.82189 .60332 L
.86339 .60332 L
.90337 .60332 L
.94184 .60332 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
 ImageSize->{288, 177.938},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztm81OAjEQx7sfsIgvsSdPevGkJoaPRE38eIgNMYGD0SDPoPGiz+ITrjvD
Usoyrbi0WGA2oZR29jfdzmz7DwsP2WT4+JRNRoMsvRlnL8PR4DW9fh4XTVEg
RJAKIb5TAfW8qJbFl8jzXEQCPxQ1eH1iKep1vcFbDB0NvdEdvH3AEO6VhsI2
V2wviPNjoq1HnHurx57KAVIwCw4cjfsMSiQ0vR1jzx9ECID+1g6fEb4hOKEY
wdmwW4gTGUpq84tkr4Ud9xjLeAFRHC26mdJO7h2ivz+6OYIScSFNPti3WbSV
km2bE+fH/carLyO8RHBCMYKzYbcQfou7Olpr42LkV3HXkpfiehYXyVvnrSLr
IksB8uNO43WXEZwNjPAcwQm1CwizrHP0TE8jFto6bxbVXQKVBtQ2IegSunlz
esutN6tfRs4z8dBN1vlxw/HayQhOKEZwNjDCjDBLM1Qc2l+Gef3tjUlNVMju
HqRqxaaTa6MkTeQ4bvw8lZdfRvw7grNhDxG4AuMC3FGMZkeodqjEjkwY5QzZ
gbxEcVA5u4tlvDCe4ugas5AaxhRObsgdg48VpoeyK69oLmiobfhc9pbbWGUA
K4+ACuR0ByM36cv1rrdP2DXUCC5t0uoEKwflcClbqkGqoBMlrOEcul4wEdTy
6d5LwO4Ket5lDduCWf8yjgo9pRDXsWMfq9s19aEyZUOdttJVvf/niOAHT/az
xA==\
\>"],
 ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.1087, -1.02675, 0.0146948, \
0.00594415}}],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"\[SkeletonIndicator]", "Graphics", "\[SkeletonIndicator]"}],
   False,
   Editable->False], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
 "The Schrodinger equation in the three regions I: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", 
    RowBox[{"-", "a"}]}], TraditionalForm]]],
 ", II: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "a"}], "<", "x", "<", "a"}], TraditionalForm]]],
 ", and III: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "a"}], TraditionalForm]]],
 " can easily be written down,\nI, III ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["\[HBar]", "2"], 
       RowBox[{"2", "m"}]]}], 
     FractionBox[
      SuperscriptBox["d", "2"], 
      SuperscriptBox["dx", "2"]], 
     RowBox[{"\[Phi]", "(", "x", ")"}]}], "=", 
    RowBox[{"E", " ", 
     RowBox[{"\[Phi]", "(", "x", ")"}]}]}], TraditionalForm]]],
 ",\nII:",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["\[HBar]", "2"], 
        RowBox[{"2", "m"}]]}], 
      FractionBox[
       SuperscriptBox["d", "2"], 
       SuperscriptBox["dx", "2"]], 
      RowBox[{"\[Phi]", "(", "x", ")"}]}], "-", 
     RowBox[{
      SubscriptBox["V", "0"], 
      RowBox[{"\[Phi]", "(", "x", ")"}]}]}], "=", 
    RowBox[{"E", " ", 
     RowBox[{"\[Phi]", "(", "x", ")"}]}]}], TraditionalForm]]],
 ".\nWe shall solve these equations for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     SubscriptBox["V", "0"]}], "<", "E", "<", "0"}], TraditionalForm]]],
 ". \nArgue that in that case the solution in regions I and III are \
exponential (real exponents), and in region II is oscillatory (sum of sines \
and cosines). \nDefine ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", " ", "=", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "m"}], 
        SuperscriptBox["\[HBar]", "2"]]}], "E"}]]}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Kappa]", "="}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     FractionBox[
      RowBox[{"2", "m"}], 
      SuperscriptBox["\[HBar]", "2"]], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["V", "0"], "+", "E"}], ")"}]}]], TraditionalForm]]],
 ". Is this a sensible definition?"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution to the bound-state problem.", "Section"],

Cell[TextData[{
 "Just to be sure, make ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ",", "\[Kappa]", ",", 
    SubscriptBox["A", "1"], ",", 
    SubscriptBox["B", "1"], ",", 
    SubscriptBox["B", "2"], ",", 
    SubscriptBox["A", "3"]}], TraditionalForm]]],
 "undefined. When they are not defined this gives some error messages..."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"k", "=."}], ";", 
   RowBox[{"\[Kappa]", "=."}], ";", 
   RowBox[{
    SubscriptBox["A", "1"], "=."}], ";", 
   RowBox[{
    SubscriptBox["B", "2"], "=."}], ";", 
   RowBox[{
    SubscriptBox["A", "3"], "=."}], ";", 
   RowBox[{
    SubscriptBox["B", "3"], "=."}], ";"}], TraditionalForm]], "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Unset", "::", "\<\"norep\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"Assignment on \\!\\(TraditionalForm\\`Subscript\\) for \
\\!\\(TraditionalForm\\`A\\_1\\) not found.\"\>"}], 
  TraditionalForm]], "Message"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Unset", "::", "\<\"norep\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"Assignment on \\!\\(TraditionalForm\\`Subscript\\) for \
\\!\\(TraditionalForm\\`B\\_2\\) not found.\"\>"}], 
  TraditionalForm]], "Message"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"Unset", "::", "\<\"norep\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"Assignment on \\!\\(TraditionalForm\\`Subscript\\) for \
\\!\\(TraditionalForm\\`A\\_3\\) not found.\"\>"}], 
  TraditionalForm]], "Message"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"General", "::", "\<\"stop\"\>"}], 
   RowBox[{
   ":", " "}], "\<\"Further output of \\!\\(TraditionalForm\\`\\(Unset :: \
\\\"norep\\\"\\)\\) will be suppressed during this calculation.\"\>"}], 
  TraditionalForm]], "Message"]
}, Open  ]],

Cell["\<\
Define the wave functions in regions I, II and III. We have an exponentially \
damped wave function in regions I and III (why?), and the full solution in \
region II.\
\>", "Text"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Phi]", "\[ImaginaryI]"], "[", "x_", "]"}], ":=", 
    RowBox[{
     SubscriptBox["A", "1"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{" ", 
       RowBox[{"k", " ", "x"}]}]]}]}], "  ", ";"}],
  TraditionalForm], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[Phi]", "II"], "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     SubscriptBox["A", "2"], 
     RowBox[{"cos", "(", 
      RowBox[{"\[Kappa]", " ", "x"}], ")"}]}], " ", "+", 
    RowBox[{
     SubscriptBox["B", "2"], 
     RowBox[{"sin", "(", 
      RowBox[{"\[Kappa]", " ", "x"}], ")"}]}]}]}], " ", ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[Phi]", "III"], "[", "x_", "]"}], ":=", 
   RowBox[{
    SubscriptBox["B", "3"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", " ", "k"}], " ", "x"}]]}]}], ";"}]}], "Input",
 AspectRatioFixed->True],

Cell[TextData[{
 "Set up the four matching equations, for the functions and their derivatives \
at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"\[PlusMinus]", 
     RowBox[{"a", "."}]}]}], TraditionalForm]]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"eqns1", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Phi]", "I"], "(", 
      RowBox[{"-", "a"}], ")"}], "==", 
     RowBox[{
      SubscriptBox["\[Phi]", "II"], "(", 
      RowBox[{"-", "a"}], ")"}]}]}], ";"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"eqns2", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Phi]", "II"], "(", "a", ")"}], "==", 
     RowBox[{
      SubscriptBox["\[Phi]", "III"], "(", "a", ")"}]}]}], ";"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"eqns3", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Phi]", "I"], "\[Prime]",
       MultilineFunction->None], "(", 
      RowBox[{"-", "a"}], ")"}], "==", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Phi]", "II"], "\[Prime]",
       MultilineFunction->None], "(", 
      RowBox[{"-", "a"}], ")"}]}]}], ";"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"eqns4", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Phi]", "II"], "\[Prime]",
       MultilineFunction->None], "(", "a", ")"}], "==", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Phi]", "III"], "\[Prime]",
       MultilineFunction->None], "(", "a", ")"}]}]}], ";"}], 
  TraditionalForm], "\n", 
 FormBox[
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{"eqns1", ",", "eqns2", ",", "eqns3", ",", "eqns4"}], "}"}]}], 
  TraditionalForm]}], "Input",
 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "a"}], " ", "k"}]], " ", 
      SubscriptBox["A", "1"]}], "==", 
     RowBox[{
      RowBox[{
       RowBox[{"cos", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["A", "2"]}], "-", 
      RowBox[{
       RowBox[{"sin", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["B", "2"]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"cos", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["A", "2"]}], "+", 
      RowBox[{
       RowBox[{"sin", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["B", "2"]}]}], "==", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "a"}], " ", "k"}]], " ", 
      SubscriptBox["B", "3"]}]}], ",", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "a"}], " ", "k"}]], " ", "k", " ", 
      SubscriptBox["A", "1"]}], "==", 
     RowBox[{
      RowBox[{"\[Kappa]", " ", 
       RowBox[{"sin", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["A", "2"]}], "+", 
      RowBox[{"\[Kappa]", " ", 
       RowBox[{"cos", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["B", "2"]}]}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Kappa]", " ", 
       RowBox[{"cos", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["B", "2"]}], "-", 
      RowBox[{"\[Kappa]", " ", 
       RowBox[{"sin", "(", 
        RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
       SubscriptBox["A", "2"]}]}], "==", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "a"}], " ", "k"}]]}], " ", "k", " ", 
      SubscriptBox["B", "3"]}]}]}], "}"}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
 "Eliminate ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "3"], TraditionalForm]]],
 "from the equations."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"solution", "=", 
   RowBox[{"Eliminate", "[", 
    RowBox[{"eqns", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["B", "3"], ",", 
       SubscriptBox["A", "1"]}], "}"}]}], "]"}]}], TraditionalForm]], "Input",\

 AspectRatioFixed->True],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[Kappa]", " ", 
     RowBox[{
      SuperscriptBox["sin", "2"], "(", 
      RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
     SubscriptBox["A", "2"], " ", 
     SubscriptBox["B", "2"]}], "==", 
    RowBox[{
     RowBox[{"-", "\[Kappa]"}], " ", 
     RowBox[{
      SuperscriptBox["cos", "2"], "(", 
      RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
     SubscriptBox["A", "2"], " ", 
     SubscriptBox["B", "2"]}]}], "\[And]", 
   RowBox[{
    RowBox[{"k", " ", 
     RowBox[{"cos", "(", 
      RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
     SubscriptBox["A", "2"]}], "==", 
    RowBox[{"\[Kappa]", " ", 
     RowBox[{"sin", "(", 
      RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
     SubscriptBox["A", "2"]}]}], "\[And]", 
   RowBox[{
    RowBox[{"k", " ", 
     RowBox[{"sin", "(", 
      RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
     SubscriptBox["B", "2"]}], "==", 
    RowBox[{
     RowBox[{"-", "\[Kappa]"}], " ", 
     RowBox[{"cos", "(", 
      RowBox[{"a", " ", "\[Kappa]"}], ")"}], " ", 
     SubscriptBox["B", "2"]}]}]}], TraditionalForm]], "Output"]
}, Open  ]],

Cell[TextData[{
 "These solutions imply ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["A", "2"], "=", 
    RowBox[{
     RowBox[{"0", "\[And]", 
      SubscriptBox["B", "2"]}], "=", "0"}]}], TraditionalForm]]],
 "!"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Assigments", "Section"],

Cell[TextData[{
 "Make a graphical representation of these two types of solutions using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Subsection"]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 600},
WindowMargins->{{181, Automatic}, {36, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"XAutomaticEncoding",
FrontEndVersion->"7.0 for Linux x86 (64-bit) (November 11, 2008)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "iso8859-1"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 46, 0, 131, "Title"],
Cell[616, 24, 113, 1, 31, "Subsubtitle"],
Cell[CellGroupData[{
Cell[754, 29, 30, 0, 78, "Section"],
Cell[787, 31, 255, 10, 53, "Text"],
Cell[CellGroupData[{
Cell[1067, 45, 428, 13, 65, "Input"],
Cell[1498, 60, 4345, 262, 186, 3362, 242, "GraphicsData", "PostScript", \
"Graphics"],
Cell[5846, 324, 166, 5, 42, "Output"]
}, Open  ]],
Cell[6027, 332, 2248, 82, 270, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8312, 419, 55, 0, 49, "Section"],
Cell[8370, 421, 345, 10, 90, "Text"],
Cell[CellGroupData[{
Cell[8740, 435, 371, 13, 76, "Input"],
Cell[9114, 450, 254, 7, 24, "Message"],
Cell[9371, 459, 254, 7, 24, "Message"],
Cell[9628, 468, 254, 7, 43, "Message"],
Cell[9885, 477, 274, 7, 62, "Message"]
}, Open  ]],
Cell[10174, 487, 190, 4, 116, "Text"],
Cell[10367, 493, 966, 34, 136, "Input"],
Cell[11336, 529, 238, 8, 64, "Text"],
Cell[CellGroupData[{
Cell[11599, 541, 1510, 52, 166, "Input"],
Cell[13112, 595, 2028, 64, 196, "Output"]
}, Open  ]],
Cell[15155, 662, 220, 10, 38, "Text"],
Cell[CellGroupData[{
Cell[15400, 676, 284, 10, 45, "Input"],
Cell[15687, 688, 1132, 35, 132, "Output"]
}, Open  ]],
Cell[16834, 726, 239, 10, 38, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17110, 741, 29, 0, 49, "Section"],
Cell[17142, 743, 162, 5, 63, "Subsection"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

