(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15159,        442]
NotebookOptionsPosition[     13811,        393]
NotebookOutlinePosition[     14224,        409]
CellTagsIndexPosition[     14181,        406]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Scattering solution to Schr\[ODoubleDot]dinger equation\
\>", "Title",
 CellChangeTimes->{{3.46882618534892*^9, 3.468826247948526*^9}}],

Cell["Gaussian potential", "Subtitle",
 CellChangeTimes->{{3.4688262553036737`*^9, 3.468826259388007*^9}}],

Cell["Niels Walet, 1998-2009", "Subsubtitle",
 CellChangeTimes->{{3.4688263353238277`*^9, 3.468826347215578*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}]], "Input",
 CellID->1603787134],

Cell["\<\
Write the Schr\[ODoubleDot]dinger equation (mass is 1/2)\
\>", "Text",
 CellChangeTimes->{{3.468826366278447*^9, 3.4688263859169693`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"x", ",", "x"}]], 
      RowBox[{"\[Phi]", "[", "x", "]"}]}]}], "+", 
    RowBox[{
     RowBox[{"V", "[", "x", "]"}], " ", 
     RowBox[{"\[Phi]", "[", "x", "]"}]}], "-", 
    RowBox[{"Energy", " ", 
     RowBox[{"\[Phi]", "[", "x", "]"}]}]}], "\[Equal]", "0"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "Energy"}], " ", 
    RowBox[{"\[Phi]", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"V", "[", "x", "]"}], " ", 
    RowBox[{"\[Phi]", "[", "x", "]"}]}], "-", 
   RowBox[{
    SuperscriptBox["\[Phi]", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}]], "Output",\

 CellChangeTimes->{{3.468826393965761*^9, 3.468826406224181*^9}, 
   3.4688384804313507`*^9, 3.468838516941854*^9}]
}, Open  ]],

Cell["Define the potential energy", "Text",
 CellChangeTimes->{{3.468826418639907*^9, 3.468826429746867*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"V", "[", "x_", "]"}], "=", 
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"-", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 CellChangeTimes->{3.468826503661043*^9, 3.468838480632563*^9, 
  3.468838517047051*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scattering", "Section",
 CellChangeTimes->{{3.468838404832693*^9, 3.468838407473514*^9}}],

Cell["\<\
Add these boundary conditions (at the left boundary to the equation). So we \
have an incoming plane wave. See that the wave gets a phase shift for \
positive x\
\>", "Text",
 CellChangeTimes->{{3.468826507371467*^9, 3.468826547910349*^9}, {
  3.46883835908845*^9, 3.468838374709484*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"scatter", "[", 
   RowBox[{"Energy_", ",", "bnd_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eqa", ",", "solna"}], "}"}], ",", 
    RowBox[{
     RowBox[{"eqa", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SubscriptBox["\[PartialD]", 
             RowBox[{"x", ",", "x"}]], 
            RowBox[{"\[Phi]", "[", "x", "]"}]}]}], "+", 
          RowBox[{
           RowBox[{"V", "[", "x", "]"}], " ", 
           RowBox[{"\[Phi]", "[", "x", "]"}]}], "-", 
          RowBox[{"Energy", " ", 
           RowBox[{"\[Phi]", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"\[Phi]", "[", 
          RowBox[{"-", "bnd"}], "]"}], "\[Equal]", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["Energy"]}], " ", "bnd"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]", "\[Prime]",
           MultilineFunction->None], "[", 
          RowBox[{"-", "bnd"}], "]"}], "\[Equal]", 
         RowBox[{
          SqrtBox["Energy"], " ", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"-", 
             SqrtBox["Energy"]}], " ", "bnd"}], "]"}]}]}]}], "}"}]}], ";", 
     RowBox[{"solna", "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{"eqa", ",", "\[Phi]", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "bnd"}], ",", "bnd"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"V", "[", "x", "]"}], ",", 
         RowBox[{
          RowBox[{"\[Phi]", "[", "x", "]"}], "/.", "\[InvisibleSpace]", 
          "solna"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{
           SqrtBox["Energy"], " ", "x"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "bnd"}], ",", "bnd"}], "}"}], ",", 
       RowBox[{"PlotLegend", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<V\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<sine wave\>\""}], 
         "}"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.468838009073656*^9, 3.468838086275687*^9}, {
  3.468838188942651*^9, 3.468838242010118*^9}, {3.468838305020418*^9, 
  3.4688383263274918`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"scatter", "[", 
    RowBox[{"Energy", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Energy", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.468838089990672*^9, 3.468838138287673*^9}, {
  3.46883827912348*^9, 3.468838283891492*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Energy$$ = 3.52, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`Energy$$], 1, 10}}, Typeset`size$$ = {
    360., {120., 124.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`Energy$709$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`Energy$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`Energy$$, $CellContext`Energy$709$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`scatter[$CellContext`Energy$$, 3], 
      "Specifications" :> {{$CellContext`Energy$$, 1, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {164., 169.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.468838113602125*^9, 3.4688381395415373`*^9}, 
   3.468838284527495*^9, 3.468838480764851*^9, 3.468838517468891*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bound States", "Section",
 CellChangeTimes->{{3.4688384537050343`*^9, 3.468838456195299*^9}}],

Cell["\<\
We can also use a shooting method to find the bound state energy: if we start \
with a growing exponential on the left, we need a decaying exponential on the \
right\
\>", "Text",
 CellChangeTimes->{{3.468827118609126*^9, 3.468827132778455*^9}, {
   3.468827182701416*^9, 3.46882719570227*^9}, {3.4688295347583923`*^9, 
   3.468829557886539*^9}, 3.4688297780123672`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"shoot", "[", 
   RowBox[{"Energy_", ",", "bnd_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"eqa", ",", "solna"}], "}"}], ",", 
    RowBox[{
     RowBox[{"eqa", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SubscriptBox["\[PartialD]", 
             RowBox[{"x", ",", "x"}]], 
            RowBox[{"\[Phi]", "[", "x", "]"}]}]}], "+", 
          RowBox[{
           RowBox[{"V", "[", "x", "]"}], " ", 
           RowBox[{"\[Phi]", "[", "x", "]"}]}]}], "==", 
         RowBox[{"Energy", " ", 
          RowBox[{"\[Phi]", "[", "x", "]"}]}]}], ",", 
        RowBox[{
         RowBox[{"\[Phi]", "[", 
          RowBox[{"-", "bnd"}], "]"}], "\[Equal]", 
         RowBox[{"Evaluate", "[", 
          FractionBox[
           RowBox[{"Exp", "[", 
            RowBox[{
             SqrtBox[
              RowBox[{"-", "Energy"}]], " ", "bnd"}], "]"}], "25."], "]"}]}], 
        ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[Phi]", "\[Prime]",
           MultilineFunction->None], "[", 
          RowBox[{"-", "bnd"}], "]"}], "\[Equal]", 
         RowBox[{"Evaluate", "[", 
          FractionBox[
           RowBox[{
            SqrtBox[
             RowBox[{"-", "Energy"}]], " ", 
            RowBox[{"Exp", "[", 
             RowBox[{
              SqrtBox[
               RowBox[{"-", "Energy"}]], " ", "bnd"}], "]"}]}], "25."], 
          "]"}]}]}], "}"}]}], ";", 
     RowBox[{"solna", "=", 
      RowBox[{"NDSolve", "[", 
       RowBox[{"eqa", ",", "\[Phi]", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "bnd"}], ",", "bnd"}], "}"}]}], "]"}]}], ";", "\n", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"V", "[", "x", "]"}], ",", 
         RowBox[{
          RowBox[{"\[Phi]", "[", "x", "]"}], "/.", "\[InvisibleSpace]", 
          "solna"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[Phi]", "'"}], "[", "x", "]"}], "/", 
           RowBox[{"\[Phi]", "[", "x", "]"}]}], "/.", "solna"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "bnd"}], ",", "bnd"}], "}"}], ",", 
       RowBox[{"PlotLegend", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
         "\"\<V\>\"", ",", "\"\<\[Phi]\>\"", ",", "\"\<\[Phi]'/\[Phi]\>\""}], 
         "}"}]}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4688300695510483`*^9, 3.468830104074058*^9}, {
  3.468830141812392*^9, 3.468830141981846*^9}, {3.4688301741157312`*^9, 
  3.468830176559311*^9}, {3.468837141180448*^9, 3.468837154939867*^9}, {
  3.468837188886415*^9, 3.4688372098451967`*^9}, {3.4688372434395437`*^9, 
  3.4688372674380913`*^9}, {3.46883732172164*^9, 3.468837368786648*^9}, {
  3.468837406762694*^9, 3.4688374228557997`*^9}, {3.468837709919928*^9, 
  3.468837717714549*^9}, {3.4688378459567537`*^9, 3.468837864782799*^9}}],

Cell["Find the energy that makes the logarithmic derivative flat", "Text",
 CellChangeTimes->{{3.4688376170664663`*^9, 3.468837641166368*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"shoot", "[", 
    RowBox[{"Energy", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Energy", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "0.001"}], ",", 
     RowBox[{"Appearance", "\[Rule]", " ", "Labeled"}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.468827114169087*^9, {3.46882716094132*^9, 3.468827161538876*^9}, {
   3.468829561991104*^9, 3.468829562280581*^9}, {3.4688299417611017`*^9, 
   3.468830062507162*^9}, {3.468830109773253*^9, 3.468830119032227*^9}, {
   3.4688372878273163`*^9, 3.468837288178401*^9}, {3.468837505780151*^9, 
   3.468837554310039*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Energy$$ = -0.335, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`Energy$$], -1, -0.001}}, Typeset`size$$ = {
    360., {120., 124.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`Energy$837$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`Energy$$ = -1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`Energy$$, $CellContext`Energy$837$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`shoot[$CellContext`Energy$$, 3], 
      "Specifications" :> {{$CellContext`Energy$$, -1, -0.001, Appearance -> 
         Labeled}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {176., 181.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.468830120445251*^9, 3.46883728869995*^9, {3.46883750850051*^9, 
   3.4688375243682337`*^9}, {3.468837556171267*^9, 3.46883759504782*^9}, {
   3.468837894554984*^9, 3.468837899317793*^9}, 3.468838481553624*^9, 
   3.468838518337511*^9, {3.468838557008481*^9, 3.468838560423381*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1094, 600},
WindowMargins->{{Automatic, 47}, {Automatic, 70}},
FrontEndVersion->"7.0 for Linux x86 (64-bit) (February 25, 2009)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "iso8859-1"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 145, 3, 75, "Title"],
Cell[715, 27, 106, 1, 38, "Subtitle"],
Cell[824, 30, 113, 1, 31, "Subsubtitle"],
Cell[940, 33, 98, 2, 42, "Input",
 CellID->1603787134],
Cell[1041, 37, 148, 3, 32, "Text"],
Cell[CellGroupData[{
Cell[1214, 44, 415, 13, 42, "Input"],
Cell[1632, 59, 486, 14, 41, "Output"]
}, Open  ]],
Cell[2133, 76, 109, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[2267, 81, 182, 6, 47, "Input"],
Cell[2452, 89, 217, 6, 47, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2706, 100, 95, 1, 78, "Section"],
Cell[2804, 103, 298, 6, 53, "Text"],
Cell[3105, 111, 2402, 69, 161, "Input"],
Cell[CellGroupData[{
Cell[5532, 184, 330, 8, 42, "Input"],
Cell[5865, 194, 1644, 33, 360, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7558, 233, 99, 1, 78, "Section"],
Cell[7660, 236, 380, 7, 53, "Text"],
Cell[8043, 245, 3042, 82, 230, "Input"],
Cell[11088, 329, 142, 1, 32, "Text"],
Cell[CellGroupData[{
Cell[11255, 334, 664, 16, 42, "Input"],
Cell[11922, 352, 1849, 36, 384, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
