(*^

::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "X Window System Mathematica Notebook Front End Version 2.2";

	X11StandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, fontName, "times";
	fontset = subtitle, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, fontName, "times";
	fontset = subsubtitle, inactive, noPageBreakBelow, noPageBreakInGroup, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, fontName, "times";
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, fontName, "times";
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, fontName, "times";
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, fontName, "times";
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, fontName, "times";
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold,  12, fontName, "courier";
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, fontName, "courier";
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, fontName, "courier";
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, fontName, "courier";
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23,  12, fontName, "courier";
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, fontName, "courier";
	fontset = name, inactive, noPageBreakInGroup, nohscroll, preserveAspect, M7, italic, B65535,  10, fontName, "times";
	fontset = header, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  12, fontName, "times";
	fontset = leftheader,  12, fontName, "times";
	fontset = footer, inactive, nohscroll, noKeepOnOnePage, preserveAspect, center, M7, italic,  12, fontName, "times";
	fontset = leftfooter,  12, fontName, "times";
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "courier";
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, fontName, "times";paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = input; preserveAspect]
k =.
:[font = input; preserveAspect]
phi1[x_]:= A1 Exp[I k x]+B1 Exp[-I k x]
:[font = input; preserveAspect]
phi2[x_] := A2 Cosh[kappa x] + B2 Sinh[kappa x]
:[font = input; preserveAspect]
phi3[x_] := A3 Exp[I k x]
:[font = input; preserveAspect]
eqns1 = phi1[-a]==phi2[-a];eqns2=phi2[a]==phi3[a];
eqns3 = phi1'[-a]==phi2'[-a]; eqns4 = phi2'[a]==phi3'[a];
eqns={eqns1,eqns2,eqns3,eqns4};
:[font = input; Cclosed; preserveAspect; startGroup]
expr=Simplify[Solve[eqns,{A3,B1,A2,B2}]]
:[font = output; output; inactive; preserveAspect; endGroup]
{{A3 -> (2*I*A1*E^(-2*I*a*k)*k*kappa)/
 
     (2*I*k*kappa*Cosh[2*a*kappa] + k^2*Sinh[2*a*kappa] - 
 
       kappa^2*Sinh[2*a*kappa]), 
 
   B1 -> (A1*E^(-2*I*a*k)*(k^2 + kappa^2)*Sinh[2*a*kappa])/
 
     (2*I*k*kappa*Cosh[2*a*kappa] + k^2*Sinh[2*a*kappa] - 
 
       kappa^2*Sinh[2*a*kappa]), 
 
   A2 -> (A1*E^(-I*a*k)*k)/
 
     (k*Cosh[a*kappa] + I*kappa*Sinh[a*kappa]), 
 
   B2 -> (A1*E^(-I*a*k)*k)/
 
     (-I*kappa*Cosh[a*kappa] - k*Sinh[a*kappa])}}
;[o]
                 -2 I a k
{{A3 -> (2 I A1 E         k kappa) / 
 
                                     2
     (2 I k kappa Cosh[2 a kappa] + k  Sinh[2 a kappa] - 
 
            2
       kappa  Sinh[2 a kappa]), 
 
              -2 I a k   2        2
   B1 -> (A1 E         (k  + kappa ) Sinh[2 a kappa]) / 
 
                                     2
     (2 I k kappa Cosh[2 a kappa] + k  Sinh[2 a kappa] - 
 
            2
       kappa  Sinh[2 a kappa]), 
 
                          -I a k
                      A1 E       k
   A2 -> ---------------------------------------, 
         k Cosh[a kappa] + I kappa Sinh[a kappa]
 
                           -I a k
                       A1 E       k
   B2 -> ----------------------------------------}}
         -I kappa Cosh[a kappa] - k Sinh[a kappa]
:[font = input; Cclosed; preserveAspect; startGroup]
expr = Flatten[expr]
:[font = output; output; inactive; preserveAspect; endGroup]
{A3 -> (2*I*A1*E^(-2*I*a*k)*k*kappa)/
 
    (2*I*k*kappa*Cosh[2*a*kappa] + k^2*Sinh[2*a*kappa] - 
 
      kappa^2*Sinh[2*a*kappa]), 
 
  B1 -> (A1*E^(-2*I*a*k)*(k^2 + kappa^2)*Sinh[2*a*kappa])/
 
    (2*I*k*kappa*Cosh[2*a*kappa] + k^2*Sinh[2*a*kappa] - 
 
      kappa^2*Sinh[2*a*kappa]), 
 
  A2 -> (A1*E^(-I*a*k)*k)/
 
    (k*Cosh[a*kappa] + I*kappa*Sinh[a*kappa]), 
 
  B2 -> (A1*E^(-I*a*k)*k)/
 
    (-I*kappa*Cosh[a*kappa] - k*Sinh[a*kappa])}
;[o]
                -2 I a k
{A3 -> (2 I A1 E         k kappa) / 
 
                                    2
    (2 I k kappa Cosh[2 a kappa] + k  Sinh[2 a kappa] - 
 
           2
      kappa  Sinh[2 a kappa]), 
 
             -2 I a k   2        2
  B1 -> (A1 E         (k  + kappa ) Sinh[2 a kappa]) / 
 
                                    2
    (2 I k kappa Cosh[2 a kappa] + k  Sinh[2 a kappa] - 
 
           2
      kappa  Sinh[2 a kappa]), 
 
                         -I a k
                     A1 E       k
  A2 -> ---------------------------------------, 
        k Cosh[a kappa] + I kappa Sinh[a kappa]
 
                          -I a k
                      A1 E       k
  B2 -> ----------------------------------------}
        -I kappa Cosh[a kappa] - k Sinh[a kappa]
:[font = input; Cclosed; preserveAspect; startGroup]
sqT = A3/A1 /. expr
:[font = output; output; inactive; preserveAspect; endGroup]
(2*I*E^(-2*I*a*k)*k*kappa)/
 
  (2*I*k*kappa*Cosh[2*a*kappa] + k^2*Sinh[2*a*kappa] - 
 
    kappa^2*Sinh[2*a*kappa])
;[o]
      -2 I a k
(2 I E         k kappa) / 
 
                                  2
  (2 I k kappa Cosh[2 a kappa] + k  Sinh[2 a kappa] - 
 
         2
    kappa  Sinh[2 a kappa])
:[font = input; preserveAspect; startGroup]
Trans=Simplify[ComplexExpand[sqT Conjugate[sqT]]]
:[font = output; output; inactive; preserveAspect; endGroup]
(8*k^2*kappa^2)/
 
  (-k^4 + 6*k^2*kappa^2 - kappa^4 + k^4*Cosh[4*a*kappa] + 
 
    2*k^2*kappa^2*Cosh[4*a*kappa] + kappa^4*Cosh[4*a*kappa])
;[o]
    2      2
(8 k  kappa ) / 
 
     4      2      2        4    4
  (-k  + 6 k  kappa  - kappa  + k  Cosh[4 a kappa] + 
 
       2      2                        4
    2 k  kappa  Cosh[4 a kappa] + kappa  Cosh[4 a kappa])
:[font = input; Cclosed; preserveAspect; startGroup]
sqR = B1/A1 /. expr
:[font = output; output; inactive; preserveAspect; endGroup]
(E^(-2*I*a*k)*(k^2 + kappa^2)*Sinh[2*a*kappa])/
 
  (2*I*k*kappa*Cosh[2*a*kappa] + k^2*Sinh[2*a*kappa] - 
 
    kappa^2*Sinh[2*a*kappa])
;[o]
  -2 I a k   2        2
(E         (k  + kappa ) Sinh[2 a kappa]) / 
 
                                  2
  (2 I k kappa Cosh[2 a kappa] + k  Sinh[2 a kappa] - 
 
         2
    kappa  Sinh[2 a kappa])
:[font = input; preserveAspect; startGroup]
Simplify[ComplexExpand[sqR Conjugate[sqR]]]
:[font = output; output; inactive; preserveAspect; endGroup]
(2*(k^2 + kappa^2)^2*Sinh[2*a*kappa]^2)/
 
  (-k^4 + 6*k^2*kappa^2 - kappa^4 + k^4*Cosh[4*a*kappa] + 
 
    2*k^2*kappa^2*Cosh[4*a*kappa] + kappa^4*Cosh[4*a*kappa])
;[o]
     2        2 2                2
(2 (k  + kappa )  Sinh[2 a kappa] ) / 
 
     4      2      2        4    4
  (-k  + 6 k  kappa  - kappa  + k  Cosh[4 a kappa] + 
 
       2      2                        4
    2 k  kappa  Cosh[4 a kappa] + kappa  Cosh[4 a kappa])
:[font = input; preserveAspect; startGroup]
Transpl = Trans /. (kappa -> 1/a Sqrt[1-k^2 a^2])
:[font = output; output; inactive; preserveAspect; endGroup]
(8*k^2*(1 - a^2*k^2))/
 
  (a^2*(-k^4 + (6*k^2*(1 - a^2*k^2))/a^2 - 
 
      (1 - a^2*k^2)^2/a^4 + k^4*Cosh[4*(1 - a^2*k^2)^(1/2)] + 
 
      (2*k^2*(1 - a^2*k^2)*Cosh[4*(1 - a^2*k^2)^(1/2)])/a^2 + 
 
      ((1 - a^2*k^2)^2*Cosh[4*(1 - a^2*k^2)^(1/2)])/a^4))
;[o]
    2       2  2
(8 k  (1 - a  k )) / 
 
                2       2  2          2  2 2
    2    4   6 k  (1 - a  k )   (1 - a  k )
  (a  (-k  + ---------------- - ------------ + 
                     2                4
                    a                a
 
       4                  2  2
      k  Cosh[4 Sqrt[1 - a  k ]] + 
 
         2       2  2                   2  2
      2 k  (1 - a  k ) Cosh[4 Sqrt[1 - a  k ]]
      ---------------------------------------- + 
                          2
                         a
 
            2  2 2                  2  2
      (1 - a  k )  Cosh[4 Sqrt[1 - a  k ]]
      ------------------------------------))
                        4
                       a
:[font = input; preserveAspect]
phi2p[x_] := A2 Cos[ kappa x] + B2 Sin[kappa x]
:[font = input; preserveAspect]
eqns1p = phi1[-a]==phi2p[-a];eqns2p=phi2p[a]==phi3[a];
eqns3p = phi1'[-a]==phi2p'[-a]; eqns4p = phi2p'[a]==phi3'[a];
eqnsp={eqns1p,eqns2p,eqns3p,eqns4p};
:[font = input; preserveAspect; startGroup]
exprp=Flatten[Simplify[Solve[eqnsp,{A3,B1,A2,B2}]]]
:[font = output; output; inactive; preserveAspect; endGroup]
{A3 -> (A1*E^(-2*I*a*k)*k*kappa)/
 
    (k*kappa*Cos[2*a*kappa] - I/2*k^2*Sin[2*a*kappa] - 
 
      I/2*kappa^2*Sin[2*a*kappa]), 
 
  B1 -> (A1*E^(-2*I*a*k)*(k^2 - kappa^2)*Sin[2*a*kappa])/
 
    (2*I*k*kappa*Cos[2*a*kappa] + k^2*Sin[2*a*kappa] + 
 
      kappa^2*Sin[2*a*kappa]), 
 
  A2 -> (A1*E^(-I*a*k)*k)/
 
    (k*Cos[a*kappa] - I*kappa*Sin[a*kappa]), 
 
  B2 -> -((A1*E^(-I*a*k)*k)/
 
      (I*kappa*Cos[a*kappa] + k*Sin[a*kappa]))}
;[o]
            -2 I a k
{A3 -> (A1 E         k kappa) / 
 
                              I  2
    (k kappa Cos[2 a kappa] - - k  Sin[2 a kappa] - 
                              2
 
      I      2
      - kappa  Sin[2 a kappa]), 
      2
 
             -2 I a k   2        2
  B1 -> (A1 E         (k  - kappa ) Sin[2 a kappa]) / 
 
                                   2
    (2 I k kappa Cos[2 a kappa] + k  Sin[2 a kappa] + 
 
           2
      kappa  Sin[2 a kappa]), 
 
                        -I a k
                    A1 E       k
  A2 -> -------------------------------------, 
        k Cos[a kappa] - I kappa Sin[a kappa]
 
                          -I a k
                      A1 E       k
  B2 -> -(-------------------------------------)}
          I kappa Cos[a kappa] + k Sin[a kappa]
:[font = input; Cclosed; preserveAspect; startGroup]
sqTp = A3/A1 /. exprp
:[font = output; output; inactive; preserveAspect; endGroup]
(E^(-2*I*a*k)*k*kappa)/
 
  (k*kappa*Cos[2*a*kappa] - I/2*k^2*Sin[2*a*kappa] - 
 
    I/2*kappa^2*Sin[2*a*kappa])
;[o]
  -2 I a k
(E         k kappa) / 
 
                            I  2
  (k kappa Cos[2 a kappa] - - k  Sin[2 a kappa] - 
                            2
 
    I      2
    - kappa  Sin[2 a kappa])
    2
:[font = input; preserveAspect; startGroup]
Transp=Simplify[sqTp ComplexExpand[Conjugate[sqTp]]]
:[font = output; output; inactive; preserveAspect; endGroup]
(8*k^2*kappa^2)/
 
  (k^4 + 6*k^2*kappa^2 + kappa^4 - k^4*Cos[4*a*kappa] + 
 
    2*k^2*kappa^2*Cos[4*a*kappa] - kappa^4*Cos[4*a*kappa])
;[o]
    2      2
(8 k  kappa ) / 
 
    4      2      2        4    4
  (k  + 6 k  kappa  + kappa  - k  Cos[4 a kappa] + 
 
       2      2                       4
    2 k  kappa  Cos[4 a kappa] - kappa  Cos[4 a kappa])
:[font = input; preserveAspect; startGroup]
Transppl = Transp /. (kappa -> 1/a Sqrt[k^2a^2-1])
:[font = output; output; inactive; preserveAspect; endGroup]
(8*k^2*(-1 + a^2*k^2))/
 
  (a^2*(k^4 + (6*k^2*(-1 + a^2*k^2))/a^2 + 
 
      (-1 + a^2*k^2)^2/a^4 - 
 
      k^4*Cos[4*(-1 + a^2*k^2)^(1/2)] + 
 
      (2*k^2*(-1 + a^2*k^2)*Cos[4*(-1 + a^2*k^2)^(1/2)])/
 
       a^2 - ((-1 + a^2*k^2)^2*Cos[4*(-1 + a^2*k^2)^(1/2)])/
 
       a^4))
;[o]
    2        2  2
(8 k  (-1 + a  k )) / 
 
               2        2  2           2  2 2
    2   4   6 k  (-1 + a  k )   (-1 + a  k )
  (a  (k  + ----------------- + ------------- - 
                    2                 4
                   a                 a
 
       4                  2  2
      k  Cos[4 Sqrt[-1 + a  k ]] + 
 
         2        2  2                   2  2
      2 k  (-1 + a  k ) Cos[4 Sqrt[-1 + a  k ]]
      ----------------------------------------- - 
                          2
                         a
 
             2  2 2                  2  2
      (-1 + a  k )  Cos[4 Sqrt[-1 + a  k ]]
      -------------------------------------))
                        4
                       a
:[font = input; preserveAspect; startGroup]
Series[Trans,{kappa,0,2}]
:[font = output; output; inactive; preserveAspect; endGroup]
SeriesData[kappa, 0, {(8*k^2)/(8*k^2 + 8*a^2*k^4), 0, 
 
   (-8*k^2*(16*a^2*k^2 + (32*a^4*k^4)/3))/
 
    (8*k^2 + 8*a^2*k^4)^2}, 0, 3, 1]
;[o]
                                      4  4
                    2      2  2   32 a  k        2
        2        8 k  (16 a  k  + --------) kappa
     8 k                             3                       3
-------------- - --------------------------------- + O[kappa]
   2      2  4               2      2  4 2
8 k  + 8 a  k            (8 k  + 8 a  k )
:[font = input; preserveAspect; startGroup]
Series[Transp,{kappa,0,2}]
:[font = output; output; inactive; preserveAspect; endGroup]
SeriesData[kappa, 0, {(8*k^2)/(8*k^2 + 8*a^2*k^4), 0, 
 
   (-8*k^2*(-16*a^2*k^2 - (32*a^4*k^4)/3))/
 
    (8*k^2 + 8*a^2*k^4)^2}, 0, 3, 1]
;[o]
                                       4  4
                    2       2  2   32 a  k        2
        2        8 k  (-16 a  k  - --------) kappa
     8 k                              3                       3
-------------- - ---------------------------------- + O[kappa]
   2      2  4               2      2  4 2
8 k  + 8 a  k            (8 k  + 8 a  k )
:[font = input; preserveAspect; startGroup]
Transpl /. a-> 5
:[font = output; output; inactive; preserveAspect; endGroup]
-192/(25*(-4801/625 + Cos[8*6^(1/2)]/625))
;[o]
            -192
-----------------------------
      4801    Cos[8 Sqrt[6]]
25 (-(----) + --------------)
      625          625
:[font = input; Cclosed; preserveAspect; startGroup]
p1=Plot[(Transpl /. a-> 5),{k,0,1/5}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174.25]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 4.7619 0.0147151 1.16758 [
[(0.05)] .2619 .01472 0 2 Msboxa
[(0.1)] .5 .01472 0 2 Msboxa
[(0.15)] .7381 .01472 0 2 Msboxa
[(0.2)] .97619 .01472 0 2 Msboxa
[(0.1)] .01131 .13147 1 0 Msboxa
[(0.2)] .01131 .24823 1 0 Msboxa
[(0.3)] .01131 .36499 1 0 Msboxa
[(0.4)] .01131 .48175 1 0 Msboxa
[(0.5)] .01131 .5985 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(0.05)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(0.1)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(0.15)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(0.2)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .13147 m
.03006 .13147 L
s
P
[(0.1)] .01131 .13147 1 0 Mshowa
p
.002 w
.02381 .24823 m
.03006 .24823 L
s
P
[(0.2)] .01131 .24823 1 0 Mshowa
p
.002 w
.02381 .36499 m
.03006 .36499 L
s
P
[(0.3)] .01131 .36499 1 0 Mshowa
p
.002 w
.02381 .48175 m
.03006 .48175 L
s
P
[(0.4)] .01131 .48175 1 0 Mshowa
p
.002 w
.02381 .5985 m
.03006 .5985 L
s
P
[(0.5)] .01131 .5985 1 0 Mshowa
p
.001 w
.02381 .03807 m
.02756 .03807 L
s
P
p
.001 w
.02381 .06142 m
.02756 .06142 L
s
P
p
.001 w
.02381 .08477 m
.02756 .08477 L
s
P
p
.001 w
.02381 .10812 m
.02756 .10812 L
s
P
p
.001 w
.02381 .15482 m
.02756 .15482 L
s
P
p
.001 w
.02381 .17818 m
.02756 .17818 L
s
P
p
.001 w
.02381 .20153 m
.02756 .20153 L
s
P
p
.001 w
.02381 .22488 m
.02756 .22488 L
s
P
p
.001 w
.02381 .27158 m
.02756 .27158 L
s
P
p
.001 w
.02381 .29493 m
.02756 .29493 L
s
P
p
.001 w
.02381 .31829 m
.02756 .31829 L
s
P
p
.001 w
.02381 .34164 m
.02756 .34164 L
s
P
p
.001 w
.02381 .38834 m
.02756 .38834 L
s
P
p
.001 w
.02381 .41169 m
.02756 .41169 L
s
P
p
.001 w
.02381 .43504 m
.02756 .43504 L
s
P
p
.001 w
.02381 .4584 m
.02756 .4584 L
s
P
p
.001 w
.02381 .5051 m
.02756 .5051 L
s
P
p
.001 w
.02381 .52845 m
.02756 .52845 L
s
P
p
.001 w
.02381 .5518 m
.02756 .5518 L
s
P
p
.001 w
.02381 .57515 m
.02756 .57515 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01472 m
.02505 .01472 L
.02629 .01472 L
.02753 .01472 L
.02877 .01472 L
.03001 .01473 L
.03125 .01474 L
.03373 .01475 L
.03621 .01478 L
.03869 .0148 L
.04365 .01487 L
.04861 .01496 L
.05357 .01506 L
.06349 .01533 L
.07341 .01568 L
.08333 .01611 L
.10317 .01719 L
.12302 .0186 L
.14286 .02033 L
.18254 .02479 L
.22222 .03064 L
.2619 .03798 L
.30159 .04692 L
.34127 .05759 L
.38095 .07014 L
.42063 .08475 L
.46032 .10161 L
.5 .12093 L
.53968 .14292 L
.57937 .16781 L
.61905 .19581 L
.65873 .22711 L
.69841 .26188 L
.7381 .30022 L
.77778 .34216 L
.81746 .38761 L
.85714 .4364 L
.89683 .48816 L
.93651 .54241 L
.97619 .60332 L
s
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
:[font = input; preserveAspect; startGroup]
p2=Plot[(Transppl /. a-> 5),{k,1/5,2}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174.25]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 -224.116 224.719 [
[(0.5)] .2619 .60332 0 2 Msboxa
[(1)] .5 .60332 0 2 Msboxa
[(1.5)] .7381 .60332 0 2 Msboxa
[(2)] .97619 .60332 0 2 Msboxa
[(0.9975)] .01131 .04152 1 0 Msboxa
[(0.998)] .01131 .15388 1 0 Msboxa
[(0.9985)] .01131 .26624 1 0 Msboxa
[(0.999)] .01131 .3786 1 0 Msboxa
[(0.9995)] .01131 .49096 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .60332 m
.2619 .60957 L
s
P
[(0.5)] .2619 .60332 0 2 Mshowa
p
.002 w
.5 .60332 m
.5 .60957 L
s
P
[(1)] .5 .60332 0 2 Mshowa
p
.002 w
.7381 .60332 m
.7381 .60957 L
s
P
[(1.5)] .7381 .60332 0 2 Mshowa
p
.002 w
.97619 .60332 m
.97619 .60957 L
s
P
[(2)] .97619 .60332 0 2 Mshowa
p
.001 w
.07143 .60332 m
.07143 .60707 L
s
P
p
.001 w
.11905 .60332 m
.11905 .60707 L
s
P
p
.001 w
.16667 .60332 m
.16667 .60707 L
s
P
p
.001 w
.21429 .60332 m
.21429 .60707 L
s
P
p
.001 w
.30952 .60332 m
.30952 .60707 L
s
P
p
.001 w
.35714 .60332 m
.35714 .60707 L
s
P
p
.001 w
.40476 .60332 m
.40476 .60707 L
s
P
p
.001 w
.45238 .60332 m
.45238 .60707 L
s
P
p
.001 w
.54762 .60332 m
.54762 .60707 L
s
P
p
.001 w
.59524 .60332 m
.59524 .60707 L
s
P
p
.001 w
.64286 .60332 m
.64286 .60707 L
s
P
p
.001 w
.69048 .60332 m
.69048 .60707 L
s
P
p
.001 w
.78571 .60332 m
.78571 .60707 L
s
P
p
.001 w
.83333 .60332 m
.83333 .60707 L
s
P
p
.001 w
.88095 .60332 m
.88095 .60707 L
s
P
p
.001 w
.92857 .60332 m
.92857 .60707 L
s
P
p
.002 w
0 .60332 m
1 .60332 L
s
P
p
.002 w
.02381 .04152 m
.03006 .04152 L
s
P
[(0.9975)] .01131 .04152 1 0 Mshowa
p
.002 w
.02381 .15388 m
.03006 .15388 L
s
P
[(0.998)] .01131 .15388 1 0 Mshowa
p
.002 w
.02381 .26624 m
.03006 .26624 L
s
P
[(0.9985)] .01131 .26624 1 0 Mshowa
p
.002 w
.02381 .3786 m
.03006 .3786 L
s
P
[(0.999)] .01131 .3786 1 0 Mshowa
p
.002 w
.02381 .49096 m
.03006 .49096 L
s
P
[(0.9995)] .01131 .49096 1 0 Mshowa
p
.001 w
.02381 .06399 m
.02756 .06399 L
s
P
p
.001 w
.02381 .08646 m
.02756 .08646 L
s
P
p
.001 w
.02381 .10894 m
.02756 .10894 L
s
P
p
.001 w
.02381 .13141 m
.02756 .13141 L
s
P
p
.001 w
.02381 .17635 m
.02756 .17635 L
s
P
p
.001 w
.02381 .19882 m
.02756 .19882 L
s
P
p
.001 w
.02381 .2213 m
.02756 .2213 L
s
P
p
.001 w
.02381 .24377 m
.02756 .24377 L
s
P
p
.001 w
.02381 .28871 m
.02756 .28871 L
s
P
p
.001 w
.02381 .31118 m
.02756 .31118 L
s
P
p
.001 w
.02381 .33366 m
.02756 .33366 L
s
P
p
.001 w
.02381 .35613 m
.02756 .35613 L
s
P
p
.001 w
.02381 .40107 m
.02756 .40107 L
s
P
p
.001 w
.02381 .42354 m
.02756 .42354 L
s
P
p
.001 w
.02381 .44602 m
.02756 .44602 L
s
P
p
.001 w
.02381 .46849 m
.02756 .46849 L
s
P
p
.001 w
.02381 .51343 m
.02756 .51343 L
s
P
p
.001 w
.02381 .5359 m
.02756 .5359 L
s
P
p
.001 w
.02381 .55838 m
.02756 .55838 L
s
P
p
.001 w
.02381 .58085 m
.02756 .58085 L
s
P
p
.001 w
.02381 .01905 m
.02756 .01905 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.19067 0 m
.19159 .11502 L
s
.19159 .11502 m
.19271 .23396 L
.19494 .41553 L
.19606 .48088 L
.19717 .53099 L
.19829 .56705 L
.1994 .59024 L
.20052 .60167 L
.20164 .60238 L
.20275 .59337 L
.20387 .5756 L
.20499 .54998 L
.2061 .51734 L
.20833 .43423 L
s
.21654 0 m
.20833 .43423 L
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.29642 0 m
.29762 .03784 L
s
.29762 .03784 m
.30655 .27112 L
.31101 .36506 L
.31548 .44276 L
.31994 .50418 L
.3244 .54983 L
.32664 .56701 L
.32887 .58064 L
.32999 .58617 L
.3311 .59088 L
.33222 .5948 L
.33333 .59794 L
.33445 .60033 L
.33557 .60201 L
.33668 .603 L
.3378 .60332 L
.33891 .60301 L
.34003 .60209 L
.34115 .6006 L
.34226 .59857 L
.34449 .59299 L
.34673 .58559 L
.35119 .5663 L
.36905 .46228 L
.37351 .43735 L
.37798 .41526 L
.38244 .39683 L
.38467 .38918 L
.3869 .38264 L
.38914 .37725 L
.39137 .37304 L
.39249 .37138 L
.3936 .37001 L
.39472 .36894 L
.39583 .36817 L
.39695 .36769 L
.39807 .36749 L
.39918 .36759 L
.4003 .36796 L
.40141 .36862 L
.40253 .36954 L
.40476 .37219 L
.40699 .37586 L
.40923 .38049 L
.41369 .39234 L
.42262 .42437 L
.44048 .50308 L
.4494 .53975 L
.45387 .55566 L
.45833 .56951 L
Mistroke
.4628 .58106 L
.46726 .5902 L
.46949 .59384 L
.47173 .59687 L
.47396 .5993 L
.47507 .6003 L
.47619 .60114 L
.47731 .60185 L
.47842 .60241 L
.47954 .60283 L
.48065 .60313 L
.48177 .60328 L
.48289 .60331 L
.484 .60322 L
.48512 .60301 L
.48624 .60268 L
.48735 .60224 L
.48958 .60104 L
.49182 .59944 L
.49405 .59749 L
.50298 .58697 L
.5119 .57408 L
.52083 .56135 L
.52976 .55087 L
.53423 .54697 L
.53646 .54541 L
.53869 .54413 L
.54092 .54313 L
.54204 .54274 L
.54315 .54241 L
.54427 .54217 L
.54539 .54199 L
.5465 .54189 L
.54762 .54185 L
.54874 .54189 L
.54985 .542 L
.55097 .54218 L
.55208 .54242 L
.5532 .54274 L
.55432 .54312 L
.55655 .54407 L
.56101 .54669 L
.56548 .55016 L
.58333 .56948 L
.60119 .58939 L
.60565 .59336 L
.61012 .59672 L
.61458 .59941 L
.61682 .60049 L
.61905 .6014 L
Mistroke
.62128 .60213 L
.62351 .60268 L
.62463 .60289 L
.62574 .60306 L
.62686 .60318 L
.62798 .60327 L
.62909 .60331 L
.63021 .60332 L
.63132 .60328 L
.63244 .60321 L
.63356 .60309 L
.63467 .60295 L
.6369 .60255 L
.63914 .60202 L
.64137 .60137 L
.64583 .59976 L
.65476 .59564 L
.67262 .58668 L
.67708 .58482 L
.68155 .58327 L
.68378 .58263 L
.68601 .58208 L
.68824 .58162 L
.69048 .58127 L
.69159 .58113 L
.69271 .58102 L
.69382 .58093 L
.69494 .58087 L
.69606 .58083 L
.69717 .58082 L
.69829 .58083 L
.6994 .58087 L
.70052 .58094 L
.70164 .58103 L
.70275 .58114 L
.70387 .58128 L
.7061 .58163 L
.70833 .58206 L
.7128 .58318 L
.71726 .58458 L
.72619 .58805 L
.74405 .59579 L
.75298 .59912 L
.75744 .60047 L
.7619 .60158 L
.76637 .60242 L
.7686 .60274 L
.77083 .60299 L
.77307 .60317 L
.77418 .60323 L
Mistroke
.7753 .60328 L
.77641 .60331 L
.77753 .60332 L
.77865 .60331 L
.77976 .6033 L
.78088 .60326 L
.78199 .60321 L
.78423 .60306 L
.78646 .60286 L
.78869 .60261 L
.79315 .60196 L
.79762 .60116 L
.81548 .59722 L
.8244 .59539 L
.82887 .59464 L
.83333 .59404 L
.8378 .59359 L
.84003 .59344 L
.84115 .59337 L
.84226 .59332 L
.84338 .59328 L
.84449 .59326 L
.84561 .59324 L
.84673 .59324 L
.84784 .59324 L
.84896 .59326 L
.85007 .59329 L
.85119 .59333 L
.85342 .59344 L
.85565 .59359 L
.86012 .59402 L
.86458 .59459 L
.86905 .59527 L
.8869 .59868 L
.89583 .60038 L
.9003 .60114 L
.90476 .6018 L
.90923 .60236 L
.91369 .60279 L
.91592 .60296 L
.91815 .6031 L
.91927 .60315 L
.92039 .6032 L
.9215 .60324 L
.92262 .60327 L
.92374 .6033 L
.92485 .60331 L
.92597 .60332 L
.92708 .60332 L
.9282 .60331 L
Mistroke
.92932 .60329 L
.93043 .60327 L
.93155 .60324 L
.93378 .60316 L
.93601 .60305 L
.94048 .60275 L
.9494 .60194 L
.95833 .60094 L
.97619 .59905 L
Mfstroke
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
:[font = input; preserveAspect; startGroup]
Show[{p1,p2},PlotRange->{{0,2},{0,1}}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174.25]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.5 0 0.618034 [
[(0.25)] .125 0 0 2 Msboxa
[(0.5)] .25 0 0 2 Msboxa
[(0.75)] .375 0 0 2 Msboxa
[(1)] .5 0 0 2 Msboxa
[(1.25)] .625 0 0 2 Msboxa
[(1.5)] .75 0 0 2 Msboxa
[(1.75)] .875 0 0 2 Msboxa
[(2)] 1 0 0 2 Msboxa
[(0)] -0.0125 0 1 0 Msboxa
[(0.2)] -0.0125 .12361 1 0 Msboxa
[(0.4)] -0.0125 .24721 1 0 Msboxa
[(0.6)] -0.0125 .37082 1 0 Msboxa
[(0.8)] -0.0125 .49443 1 0 Msboxa
[(1)] -0.0125 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.125 0 m
.125 .00625 L
s
P
[(0.25)] .125 0 0 2 Mshowa
p
.002 w
.25 0 m
.25 .00625 L
s
P
[(0.5)] .25 0 0 2 Mshowa
p
.002 w
.375 0 m
.375 .00625 L
s
P
[(0.75)] .375 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(1)] .5 0 0 2 Mshowa
p
.002 w
.625 0 m
.625 .00625 L
s
P
[(1.25)] .625 0 0 2 Mshowa
p
.002 w
.75 0 m
.75 .00625 L
s
P
[(1.5)] .75 0 0 2 Mshowa
p
.002 w
.875 0 m
.875 .00625 L
s
P
[(1.75)] .875 0 0 2 Mshowa
p
.002 w
1 0 m
1 .00625 L
s
P
[(2)] 1 0 0 2 Mshowa
p
.001 w
.025 0 m
.025 .00375 L
s
P
p
.001 w
.05 0 m
.05 .00375 L
s
P
p
.001 w
.075 0 m
.075 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.15 0 m
.15 .00375 L
s
P
p
.001 w
.175 0 m
.175 .00375 L
s
P
p
.001 w
.2 0 m
.2 .00375 L
s
P
p
.001 w
.225 0 m
.225 .00375 L
s
P
p
.001 w
.275 0 m
.275 .00375 L
s
P
p
.001 w
.3 0 m
.3 .00375 L
s
P
p
.001 w
.325 0 m
.325 .00375 L
s
P
p
.001 w
.35 0 m
.35 .00375 L
s
P
p
.001 w
.4 0 m
.4 .00375 L
s
P
p
.001 w
.425 0 m
.425 .00375 L
s
P
p
.001 w
.45 0 m
.45 .00375 L
s
P
p
.001 w
.475 0 m
.475 .00375 L
s
P
p
.001 w
.525 0 m
.525 .00375 L
s
P
p
.001 w
.55 0 m
.55 .00375 L
s
P
p
.001 w
.575 0 m
.575 .00375 L
s
P
p
.001 w
.6 0 m
.6 .00375 L
s
P
p
.001 w
.65 0 m
.65 .00375 L
s
P
p
.001 w
.675 0 m
.675 .00375 L
s
P
p
.001 w
.7 0 m
.7 .00375 L
s
P
p
.001 w
.725 0 m
.725 .00375 L
s
P
p
.001 w
.775 0 m
.775 .00375 L
s
P
p
.001 w
.8 0 m
.8 .00375 L
s
P
p
.001 w
.825 0 m
.825 .00375 L
s
P
p
.001 w
.85 0 m
.85 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.925 0 m
.925 .00375 L
s
P
p
.001 w
.95 0 m
.95 .00375 L
s
P
p
.001 w
.975 0 m
.975 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 Mshowa
p
.002 w
0 .12361 m
.00625 .12361 L
s
P
[(0.2)] -0.0125 .12361 1 0 Mshowa
p
.002 w
0 .24721 m
.00625 .24721 L
s
P
[(0.4)] -0.0125 .24721 1 0 Mshowa
p
.002 w
0 .37082 m
.00625 .37082 L
s
P
[(0.6)] -0.0125 .37082 1 0 Mshowa
p
.002 w
0 .49443 m
.00625 .49443 L
s
P
[(0.8)] -0.0125 .49443 1 0 Mshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(1)] -0.0125 .61803 1 0 Mshowa
p
.001 w
0 .02472 m
.00375 .02472 L
s
P
p
.001 w
0 .04944 m
.00375 .04944 L
s
P
p
.001 w
0 .07416 m
.00375 .07416 L
s
P
p
.001 w
0 .09889 m
.00375 .09889 L
s
P
p
.001 w
0 .14833 m
.00375 .14833 L
s
P
p
.001 w
0 .17305 m
.00375 .17305 L
s
P
p
.001 w
0 .19777 m
.00375 .19777 L
s
P
p
.001 w
0 .22249 m
.00375 .22249 L
s
P
p
.001 w
0 .27193 m
.00375 .27193 L
s
P
p
.001 w
0 .29666 m
.00375 .29666 L
s
P
p
.001 w
0 .32138 m
.00375 .32138 L
s
P
p
.001 w
0 .3461 m
.00375 .3461 L
s
P
p
.001 w
0 .39554 m
.00375 .39554 L
s
P
p
.001 w
0 .42026 m
.00375 .42026 L
s
P
p
.001 w
0 .44498 m
.00375 .44498 L
s
P
p
.001 w
0 .46971 m
.00375 .46971 L
s
P
p
.001 w
0 .51915 m
.00375 .51915 L
s
P
p
.001 w
0 .54387 m
.00375 .54387 L
s
P
p
.001 w
0 .56859 m
.00375 .56859 L
s
P
p
.001 w
0 .59331 m
.00375 .59331 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
0 0 m
.00013 0 L
.00026 0 L
.00039 0 L
.00052 1e-05 L
.00065 1e-05 L
.00078 1e-05 L
.00104 2e-05 L
.0013 3e-05 L
.00156 5e-05 L
.00208 8e-05 L
.0026 .00013 L
.00313 .00018 L
.00417 .00033 L
.00521 .00051 L
.00625 .00074 L
.00833 .00131 L
.01042 .00206 L
.0125 .00297 L
.01667 .00533 L
.02083 .00843 L
.025 .01232 L
.02917 .01705 L
.03333 .02269 L
.0375 .02934 L
.04167 .03707 L
.04583 .046 L
.05 .05622 L
.05417 .06786 L
.05833 .08104 L
.0625 .09586 L
.06667 .11243 L
.07083 .13083 L
.075 .15113 L
.07917 .17332 L
.08333 .19739 L
.0875 .22321 L
.09167 .25061 L
.09583 .27933 L
.1 .31157 L
s
P
P
p
p
.004 w
.1 .31157 m
.11875 .44243 L
.12813 .49957 L
.1375 .54497 L
.14219 .56285 L
.14688 .5776 L
.15156 .58945 L
.15625 .59868 L
.16094 .60564 L
.16328 .60837 L
.16563 .61067 L
.16797 .61257 L
.17031 .61412 L
.17266 .61535 L
.175 .61631 L
.17617 .61669 L
.17734 .61702 L
.17969 .61752 L
.18086 .6177 L
.18203 .61784 L
.1832 .61793 L
.18438 .618 L
.18555 .61803 L
.18672 .61803 L
.18789 .61801 L
.18906 .61796 L
.19023 .61789 L
.19141 .6178 L
.19375 .61757 L
.20313 .61627 L
.2125 .61487 L
.21719 .61428 L
.22188 .61379 L
.22656 .61343 L
.22891 .6133 L
.23008 .61324 L
.23125 .6132 L
.23242 .61316 L
.23359 .61313 L
.23477 .61311 L
.23594 .61309 L
.23711 .61308 L
.23828 .61308 L
.23945 .61309 L
.24063 .61311 L
.2418 .61313 L
.24297 .61315 L
.24531 .61323 L
.24766 .61332 L
.25 .61344 L
Mistroke
.25469 .61373 L
.25938 .61407 L
.26875 .61487 L
.27812 .61571 L
.2875 .61648 L
.29688 .61712 L
.30156 .61738 L
.30625 .61759 L
.31094 .61776 L
.31562 .61789 L
.31797 .61793 L
.32031 .61797 L
.32148 .61799 L
.32266 .618 L
.32383 .61801 L
.325 .61802 L
.32617 .61803 L
.32734 .61803 L
.32852 .61803 L
.32969 .61803 L
.33086 .61803 L
.33203 .61803 L
.3332 .61803 L
.33438 .61802 L
.33672 .61801 L
.33906 .61799 L
.34375 .61793 L
.3625 .61765 L
.36719 .61758 L
.37187 .61752 L
.37656 .61747 L
.37891 .61745 L
.38125 .61743 L
.38359 .61741 L
.38594 .6174 L
.38711 .6174 L
.38828 .61739 L
.38945 .61739 L
.39062 .61739 L
.3918 .61739 L
.39297 .61739 L
.39414 .61739 L
.39531 .61739 L
.39648 .61739 L
.39766 .61739 L
.4 .6174 L
.40234 .61741 L
.40469 .61742 L
.40937 .61745 L
.41875 .61754 L
Mistroke
.4375 .61776 L
.44687 .61786 L
.45156 .6179 L
.45625 .61794 L
.46094 .61797 L
.46562 .618 L
.46797 .61801 L
.47031 .61802 L
.47266 .61802 L
.47383 .61803 L
.475 .61803 L
.47617 .61803 L
.47734 .61803 L
.47852 .61803 L
.47969 .61803 L
.48086 .61803 L
.48203 .61803 L
.4832 .61803 L
.48437 .61803 L
.48555 .61803 L
.48672 .61803 L
.48906 .61803 L
.49141 .61802 L
.49375 .61802 L
.50312 .61799 L
.5125 .61795 L
.52187 .61792 L
.53125 .61789 L
.53594 .61788 L
.53828 .61787 L
.54062 .61787 L
.54297 .61787 L
.54414 .61787 L
.54531 .61787 L
.54648 .61787 L
.54766 .61787 L
.54883 .61787 L
.55 .61786 L
.55117 .61787 L
.55234 .61787 L
.55352 .61787 L
.55469 .61787 L
.55586 .61787 L
.55703 .61787 L
.55937 .61787 L
.56406 .61788 L
.56875 .61789 L
.5875 .61794 L
.60625 .618 L
.61094 .61801 L
Mistroke
.61562 .61802 L
.62031 .61802 L
.62266 .61803 L
.625 .61803 L
.62734 .61803 L
.62969 .61803 L
.63086 .61803 L
.63203 .61803 L
.6332 .61803 L
.63437 .61803 L
.63555 .61803 L
.63672 .61803 L
.63789 .61803 L
.63906 .61803 L
.64023 .61803 L
.64141 .61803 L
.64375 .61803 L
.64609 .61803 L
.64844 .61803 L
.65312 .61802 L
.6625 .61801 L
.68125 .61799 L
.68594 .61798 L
.69062 .61798 L
.69297 .61798 L
.69531 .61798 L
.69766 .61797 L
.7 .61797 L
.70117 .61797 L
.70234 .61797 L
.70352 .61797 L
.70469 .61797 L
.70586 .61797 L
.70703 .61797 L
.7082 .61797 L
.70937 .61797 L
.71055 .61797 L
.71172 .61797 L
.71289 .61797 L
.71406 .61797 L
.71641 .61797 L
.71875 .61798 L
.72344 .61798 L
.72812 .61798 L
.7375 .61799 L
.75625 .61801 L
.76562 .61802 L
.77031 .61803 L
.775 .61803 L
.77969 .61803 L
Mistroke
.78203 .61803 L
.78437 .61803 L
.78672 .61803 L
.78789 .61803 L
.78906 .61803 L
.79023 .61803 L
.79141 .61803 L
.79258 .61803 L
.79375 .61803 L
.79492 .61803 L
.79609 .61803 L
.79844 .61803 L
.80078 .61803 L
.80312 .61803 L
.80781 .61803 L
.8125 .61803 L
.83125 .61802 L
.84062 .61801 L
.84531 .61801 L
.85 .61801 L
.85469 .61801 L
.85703 .61801 L
.8582 .61801 L
.85937 .61801 L
.86055 .61801 L
.86172 .61801 L
.86289 .61801 L
.86406 .61801 L
.86523 .61801 L
.86641 .61801 L
.86758 .61801 L
.86875 .61801 L
.87109 .61801 L
.87344 .61801 L
.87812 .61801 L
.88281 .61801 L
.8875 .61801 L
.90625 .61802 L
.91562 .61803 L
.92031 .61803 L
.925 .61803 L
.92969 .61803 L
.93437 .61803 L
.93672 .61803 L
.93906 .61803 L
.94023 .61803 L
.94141 .61803 L
.94258 .61803 L
.94375 .61803 L
.94492 .61803 L
Mistroke
.94609 .61803 L
.94727 .61803 L
.94844 .61803 L
.94961 .61803 L
.95078 .61803 L
.95195 .61803 L
.95312 .61803 L
.95547 .61803 L
.95781 .61803 L
.9625 .61803 L
.97187 .61803 L
.98125 .61803 L
1 .61802 L
Mfstroke
P
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
:[font = input; Cclosed; preserveAspect; startGroup]
p1=Plot[(Transpl /. a-> 2),{k,0,1/2}]
:[font = message; inactive; preserveAspect]
                                 1
Power::infy: Infinite expression -- encountered.
                                 0.
:[font = message; inactive; preserveAspect]
Infinity::indet: 
                            0. 2. ComplexInfinity
   Indeterminate expression --------------------- encountered.
                                      4
:[font = message; inactive; preserveAspect]
Plot::plnr: CompiledFunction[{k}, <<1>>, -CompiledCode-][k]
     is not a machine-size real number at k = 0.5.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174.25]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 1.90725 0.0147151 1.18079 [
[(0.1)] .21453 .01472 0 2 Msboxa
[(0.2)] .40526 .01472 0 2 Msboxa
[(0.3)] .59598 .01472 0 2 Msboxa
[(0.4)] .78671 .01472 0 2 Msboxa
[(0.5)] .97743 .01472 0 2 Msboxa
[(0.1)] .01131 .13279 1 0 Msboxa
[(0.2)] .01131 .25087 1 0 Msboxa
[(0.3)] .01131 .36895 1 0 Msboxa
[(0.4)] .01131 .48703 1 0 Msboxa
[(0.5)] .01131 .60511 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21453 .01472 m
.21453 .02097 L
s
P
[(0.1)] .21453 .01472 0 2 Mshowa
p
.002 w
.40526 .01472 m
.40526 .02097 L
s
P
[(0.2)] .40526 .01472 0 2 Mshowa
p
.002 w
.59598 .01472 m
.59598 .02097 L
s
P
[(0.3)] .59598 .01472 0 2 Mshowa
p
.002 w
.78671 .01472 m
.78671 .02097 L
s
P
[(0.4)] .78671 .01472 0 2 Mshowa
p
.002 w
.97743 .01472 m
.97743 .02097 L
s
P
[(0.5)] .97743 .01472 0 2 Mshowa
p
.001 w
.06195 .01472 m
.06195 .01847 L
s
P
p
.001 w
.1001 .01472 m
.1001 .01847 L
s
P
p
.001 w
.13824 .01472 m
.13824 .01847 L
s
P
p
.001 w
.17639 .01472 m
.17639 .01847 L
s
P
p
.001 w
.25268 .01472 m
.25268 .01847 L
s
P
p
.001 w
.29082 .01472 m
.29082 .01847 L
s
P
p
.001 w
.32897 .01472 m
.32897 .01847 L
s
P
p
.001 w
.36711 .01472 m
.36711 .01847 L
s
P
p
.001 w
.4434 .01472 m
.4434 .01847 L
s
P
p
.001 w
.48155 .01472 m
.48155 .01847 L
s
P
p
.001 w
.51969 .01472 m
.51969 .01847 L
s
P
p
.001 w
.55784 .01472 m
.55784 .01847 L
s
P
p
.001 w
.63413 .01472 m
.63413 .01847 L
s
P
p
.001 w
.67227 .01472 m
.67227 .01847 L
s
P
p
.001 w
.71042 .01472 m
.71042 .01847 L
s
P
p
.001 w
.74856 .01472 m
.74856 .01847 L
s
P
p
.001 w
.82485 .01472 m
.82485 .01847 L
s
P
p
.001 w
.863 .01472 m
.863 .01847 L
s
P
p
.001 w
.90114 .01472 m
.90114 .01847 L
s
P
p
.001 w
.93929 .01472 m
.93929 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .13279 m
.03006 .13279 L
s
P
[(0.1)] .01131 .13279 1 0 Mshowa
p
.002 w
.02381 .25087 m
.03006 .25087 L
s
P
[(0.2)] .01131 .25087 1 0 Mshowa
p
.002 w
.02381 .36895 m
.03006 .36895 L
s
P
[(0.3)] .01131 .36895 1 0 Mshowa
p
.002 w
.02381 .48703 m
.03006 .48703 L
s
P
[(0.4)] .01131 .48703 1 0 Mshowa
p
.002 w
.02381 .60511 m
.03006 .60511 L
s
P
[(0.5)] .01131 .60511 1 0 Mshowa
p
.001 w
.02381 .03833 m
.02756 .03833 L
s
P
p
.001 w
.02381 .06195 m
.02756 .06195 L
s
P
p
.001 w
.02381 .08556 m
.02756 .08556 L
s
P
p
.001 w
.02381 .10918 m
.02756 .10918 L
s
P
p
.001 w
.02381 .15641 m
.02756 .15641 L
s
P
p
.001 w
.02381 .18003 m
.02756 .18003 L
s
P
p
.001 w
.02381 .20364 m
.02756 .20364 L
s
P
p
.001 w
.02381 .22726 m
.02756 .22726 L
s
P
p
.001 w
.02381 .27449 m
.02756 .27449 L
s
P
p
.001 w
.02381 .29811 m
.02756 .29811 L
s
P
p
.001 w
.02381 .32172 m
.02756 .32172 L
s
P
p
.001 w
.02381 .34534 m
.02756 .34534 L
s
P
p
.001 w
.02381 .39257 m
.02756 .39257 L
s
P
p
.001 w
.02381 .41619 m
.02756 .41619 L
s
P
p
.001 w
.02381 .4398 m
.02756 .4398 L
s
P
p
.001 w
.02381 .46342 m
.02756 .46342 L
s
P
p
.001 w
.02381 .51065 m
.02756 .51065 L
s
P
p
.001 w
.02381 .53426 m
.02756 .53426 L
s
P
p
.001 w
.02381 .55788 m
.02756 .55788 L
s
P
p
.001 w
.02381 .5815 m
.02756 .5815 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01472 m
.02505 .01472 L
.02629 .01472 L
.02753 .01472 L
.02878 .01472 L
.03002 .01473 L
.03126 .01474 L
.03374 .01475 L
.03623 .01478 L
.03871 .0148 L
.04368 .01487 L
.04864 .01496 L
.05361 .01507 L
.06354 .01534 L
.07348 .01569 L
.08341 .01612 L
.10328 .01722 L
.12315 .01864 L
.14301 .02039 L
.18275 .0249 L
.22248 .03082 L
.26222 .03825 L
.30195 .04728 L
.34168 .05807 L
.38142 .07077 L
.42115 .08554 L
.46089 .10259 L
.50062 .12213 L
.54036 .14437 L
.58009 .16954 L
.61982 .19786 L
.65956 .22952 L
.69929 .26468 L
.73903 .30345 L
.77876 .34586 L
.8185 .39183 L
.85823 .44117 L
.89796 .49352 L
.9377 .54839 L
.95757 .57656 L
.9675 .5908 L
.97247 .59795 L
.97495 .60153 L
.97619 .60332 L
s
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
:[font = input; preserveAspect; startGroup]
p2=Plot[(Transppl /. a-> 2),{k,1/2,2}]
:[font = message; inactive; preserveAspect]
                                 1
Power::infy: Infinite expression -- encountered.
                                 0.
:[font = message; inactive; preserveAspect]
Infinity::indet: 
                            0. 2. ComplexInfinity
   Indeterminate expression --------------------- encountered.
                                      4
:[font = message; inactive; preserveAspect]
Plot::plnr: CompiledFunction[{k}, <<1>>, -CompiledCode-][k]
     is not a machine-size real number at k = 0.5.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174.25]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.295306 0.635748 -28.9089 29.5122 [
[(0.6)] .08614 .60332 0 2 Msboxa
[(0.8)] .21329 .60332 0 2 Msboxa
[(1.2)] .46759 .60332 0 2 Msboxa
[(1.4)] .59474 .60332 0 2 Msboxa
[(1.6)] .72189 .60332 0 2 Msboxa
[(1.8)] .84904 .60332 0 2 Msboxa
[(2)] .97619 .60332 0 2 Msboxa
[(0.98)] .32794 .01308 1 0 Msboxa
[(0.985)] .32794 .16064 1 0 Msboxa
[(0.99)] .32794 .3082 1 0 Msboxa
[(0.995)] .32794 .45576 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.08614 .60332 m
.08614 .60957 L
s
P
[(0.6)] .08614 .60332 0 2 Mshowa
p
.002 w
.21329 .60332 m
.21329 .60957 L
s
P
[(0.8)] .21329 .60332 0 2 Mshowa
p
.002 w
.46759 .60332 m
.46759 .60957 L
s
P
[(1.2)] .46759 .60332 0 2 Mshowa
p
.002 w
.59474 .60332 m
.59474 .60957 L
s
P
[(1.4)] .59474 .60332 0 2 Mshowa
p
.002 w
.72189 .60332 m
.72189 .60957 L
s
P
[(1.6)] .72189 .60332 0 2 Mshowa
p
.002 w
.84904 .60332 m
.84904 .60957 L
s
P
[(1.8)] .84904 .60332 0 2 Mshowa
p
.002 w
.97619 .60332 m
.97619 .60957 L
s
P
[(2)] .97619 .60332 0 2 Mshowa
p
.001 w
.11157 .60332 m
.11157 .60707 L
s
P
p
.001 w
.137 .60332 m
.137 .60707 L
s
P
p
.001 w
.16243 .60332 m
.16243 .60707 L
s
P
p
.001 w
.18786 .60332 m
.18786 .60707 L
s
P
p
.001 w
.23872 .60332 m
.23872 .60707 L
s
P
p
.001 w
.26415 .60332 m
.26415 .60707 L
s
P
p
.001 w
.28958 .60332 m
.28958 .60707 L
s
P
p
.001 w
.31501 .60332 m
.31501 .60707 L
s
P
p
.001 w
.36587 .60332 m
.36587 .60707 L
s
P
p
.001 w
.3913 .60332 m
.3913 .60707 L
s
P
p
.001 w
.41673 .60332 m
.41673 .60707 L
s
P
p
.001 w
.44216 .60332 m
.44216 .60707 L
s
P
p
.001 w
.49302 .60332 m
.49302 .60707 L
s
P
p
.001 w
.51845 .60332 m
.51845 .60707 L
s
P
p
.001 w
.54388 .60332 m
.54388 .60707 L
s
P
p
.001 w
.56931 .60332 m
.56931 .60707 L
s
P
p
.001 w
.62017 .60332 m
.62017 .60707 L
s
P
p
.001 w
.6456 .60332 m
.6456 .60707 L
s
P
p
.001 w
.67103 .60332 m
.67103 .60707 L
s
P
p
.001 w
.69646 .60332 m
.69646 .60707 L
s
P
p
.001 w
.74732 .60332 m
.74732 .60707 L
s
P
p
.001 w
.77275 .60332 m
.77275 .60707 L
s
P
p
.001 w
.79818 .60332 m
.79818 .60707 L
s
P
p
.001 w
.82361 .60332 m
.82361 .60707 L
s
P
p
.001 w
.87447 .60332 m
.87447 .60707 L
s
P
p
.001 w
.8999 .60332 m
.8999 .60707 L
s
P
p
.001 w
.92533 .60332 m
.92533 .60707 L
s
P
p
.001 w
.95076 .60332 m
.95076 .60707 L
s
P
p
.001 w
.06071 .60332 m
.06071 .60707 L
s
P
p
.001 w
.03528 .60332 m
.03528 .60707 L
s
P
p
.001 w
.00985 .60332 m
.00985 .60707 L
s
P
p
.002 w
0 .60332 m
1 .60332 L
s
P
p
.002 w
.34044 .01308 m
.34669 .01308 L
s
P
[(0.98)] .32794 .01308 1 0 Mshowa
p
.002 w
.34044 .16064 m
.34669 .16064 L
s
P
[(0.985)] .32794 .16064 1 0 Mshowa
p
.002 w
.34044 .3082 m
.34669 .3082 L
s
P
[(0.99)] .32794 .3082 1 0 Mshowa
p
.002 w
.34044 .45576 m
.34669 .45576 L
s
P
[(0.995)] .32794 .45576 1 0 Mshowa
p
.001 w
.34044 .04259 m
.34419 .04259 L
s
P
p
.001 w
.34044 .0721 m
.34419 .0721 L
s
P
p
.001 w
.34044 .10161 m
.34419 .10161 L
s
P
p
.001 w
.34044 .13112 m
.34419 .13112 L
s
P
p
.001 w
.34044 .19015 m
.34419 .19015 L
s
P
p
.001 w
.34044 .21966 m
.34419 .21966 L
s
P
p
.001 w
.34044 .24917 m
.34419 .24917 L
s
P
p
.001 w
.34044 .27868 m
.34419 .27868 L
s
P
p
.001 w
.34044 .33771 m
.34419 .33771 L
s
P
p
.001 w
.34044 .36722 m
.34419 .36722 L
s
P
p
.001 w
.34044 .39673 m
.34419 .39673 L
s
P
p
.001 w
.34044 .42625 m
.34419 .42625 L
s
P
p
.001 w
.34044 .48527 m
.34419 .48527 L
s
P
p
.001 w
.34044 .51478 m
.34419 .51478 L
s
P
p
.001 w
.34044 .54429 m
.34419 .54429 L
s
P
p
.001 w
.34044 .57381 m
.34419 .57381 L
s
P
p
.002 w
.34044 0 m
.34044 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
s
s
s
s
s
s
s
s
s
s
s
s
s
s
.21595 0 m
.22124 .10078 L
s
.22124 .10078 m
.23117 .2516 L
.24111 .36888 L
.25104 .4572 L
.25601 .49186 L
.26097 .52086 L
.26594 .54469 L
.27091 .56381 L
.27587 .57866 L
.27836 .58461 L
.28084 .58965 L
.28332 .59382 L
.28581 .59717 L
.28829 .59975 L
.28953 .60077 L
.29077 .6016 L
.29202 .60227 L
.29326 .60276 L
.2945 .6031 L
.29574 .60328 L
.29698 .60331 L
.29822 .6032 L
.29947 .60294 L
.30071 .60254 L
.30319 .60136 L
.30567 .59968 L
.31064 .59498 L
.31561 .58871 L
.32057 .58111 L
.34044 .54168 L
.38018 .45227 L
.40004 .41546 L
.40998 .40062 L
.41991 .38843 L
.42984 .37899 L
.43481 .3753 L
.43978 .3723 L
.44474 .36997 L
.44723 .36906 L
.44971 .36831 L
.45219 .36772 L
.45344 .36749 L
.45468 .36729 L
.45592 .36714 L
.45716 .36703 L
.4584 .36695 L
.45964 .36691 L
.46089 .36692 L
.46213 .36695 L
.46337 .36703 L
Mistroke
.46461 .36715 L
.46585 .3673 L
.4671 .36748 L
.46958 .36797 L
.47206 .36859 L
.47455 .36936 L
.47951 .37129 L
.48945 .37666 L
.49938 .38388 L
.51925 .40284 L
.53911 .42625 L
.57885 .47892 L
.61858 .52905 L
.63845 .55032 L
.65832 .56815 L
.67818 .58223 L
.68812 .58785 L
.69805 .59252 L
.70798 .59629 L
.71792 .5992 L
.72288 .60034 L
.72785 .60128 L
.73282 .60204 L
.7353 .60235 L
.73778 .60261 L
.74027 .60283 L
.74275 .60301 L
.74523 .60315 L
.74648 .6032 L
.74772 .60324 L
.74896 .60328 L
.7502 .6033 L
.75144 .60331 L
.75269 .60332 L
.75393 .60331 L
.75517 .6033 L
.75641 .60328 L
.75765 .60325 L
.76014 .60316 L
.76262 .60304 L
.76759 .6027 L
.77255 .60223 L
.77752 .60166 L
.79739 .59846 L
.81725 .59422 L
.85699 .5848 L
.87685 .58051 L
.89672 .57695 L
.90666 .57551 L
.91659 .57434 L
Mistroke
.92156 .57385 L
.92652 .57343 L
.93149 .57308 L
.93646 .57279 L
.93894 .57268 L
.94142 .57258 L
.94391 .5725 L
.94639 .57244 L
.94763 .57241 L
.94887 .57239 L
.95011 .57237 L
.95136 .57236 L
.9526 .57235 L
.95384 .57235 L
.95508 .57235 L
.95632 .57235 L
.95757 .57236 L
.95881 .57237 L
.96005 .57239 L
.96129 .57241 L
.96377 .57246 L
.96626 .57253 L
.97122 .57272 L
.97619 .57297 L
Mfstroke
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
:[font = input; preserveAspect; startGroup]
Show[{p1,p2},PlotRange->{{0,2},{0,1}}]
:[font = postscript; PostScript; formatAsPostScript; output; inactive; preserveAspect; pictureLeft = 34; pictureWidth = 282; pictureHeight = 174.25]
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.5 0 0.618034 [
[(0.25)] .125 0 0 2 Msboxa
[(0.5)] .25 0 0 2 Msboxa
[(0.75)] .375 0 0 2 Msboxa
[(1)] .5 0 0 2 Msboxa
[(1.25)] .625 0 0 2 Msboxa
[(1.5)] .75 0 0 2 Msboxa
[(1.75)] .875 0 0 2 Msboxa
[(2)] 1 0 0 2 Msboxa
[(0)] -0.0125 0 1 0 Msboxa
[(0.2)] -0.0125 .12361 1 0 Msboxa
[(0.4)] -0.0125 .24721 1 0 Msboxa
[(0.6)] -0.0125 .37082 1 0 Msboxa
[(0.8)] -0.0125 .49443 1 0 Msboxa
[(1)] -0.0125 .61803 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.125 0 m
.125 .00625 L
s
P
[(0.25)] .125 0 0 2 Mshowa
p
.002 w
.25 0 m
.25 .00625 L
s
P
[(0.5)] .25 0 0 2 Mshowa
p
.002 w
.375 0 m
.375 .00625 L
s
P
[(0.75)] .375 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(1)] .5 0 0 2 Mshowa
p
.002 w
.625 0 m
.625 .00625 L
s
P
[(1.25)] .625 0 0 2 Mshowa
p
.002 w
.75 0 m
.75 .00625 L
s
P
[(1.5)] .75 0 0 2 Mshowa
p
.002 w
.875 0 m
.875 .00625 L
s
P
[(1.75)] .875 0 0 2 Mshowa
p
.002 w
1 0 m
1 .00625 L
s
P
[(2)] 1 0 0 2 Mshowa
p
.001 w
.025 0 m
.025 .00375 L
s
P
p
.001 w
.05 0 m
.05 .00375 L
s
P
p
.001 w
.075 0 m
.075 .00375 L
s
P
p
.001 w
.1 0 m
.1 .00375 L
s
P
p
.001 w
.15 0 m
.15 .00375 L
s
P
p
.001 w
.175 0 m
.175 .00375 L
s
P
p
.001 w
.2 0 m
.2 .00375 L
s
P
p
.001 w
.225 0 m
.225 .00375 L
s
P
p
.001 w
.275 0 m
.275 .00375 L
s
P
p
.001 w
.3 0 m
.3 .00375 L
s
P
p
.001 w
.325 0 m
.325 .00375 L
s
P
p
.001 w
.35 0 m
.35 .00375 L
s
P
p
.001 w
.4 0 m
.4 .00375 L
s
P
p
.001 w
.425 0 m
.425 .00375 L
s
P
p
.001 w
.45 0 m
.45 .00375 L
s
P
p
.001 w
.475 0 m
.475 .00375 L
s
P
p
.001 w
.525 0 m
.525 .00375 L
s
P
p
.001 w
.55 0 m
.55 .00375 L
s
P
p
.001 w
.575 0 m
.575 .00375 L
s
P
p
.001 w
.6 0 m
.6 .00375 L
s
P
p
.001 w
.65 0 m
.65 .00375 L
s
P
p
.001 w
.675 0 m
.675 .00375 L
s
P
p
.001 w
.7 0 m
.7 .00375 L
s
P
p
.001 w
.725 0 m
.725 .00375 L
s
P
p
.001 w
.775 0 m
.775 .00375 L
s
P
p
.001 w
.8 0 m
.8 .00375 L
s
P
p
.001 w
.825 0 m
.825 .00375 L
s
P
p
.001 w
.85 0 m
.85 .00375 L
s
P
p
.001 w
.9 0 m
.9 .00375 L
s
P
p
.001 w
.925 0 m
.925 .00375 L
s
P
p
.001 w
.95 0 m
.95 .00375 L
s
P
p
.001 w
.975 0 m
.975 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 Mshowa
p
.002 w
0 .12361 m
.00625 .12361 L
s
P
[(0.2)] -0.0125 .12361 1 0 Mshowa
p
.002 w
0 .24721 m
.00625 .24721 L
s
P
[(0.4)] -0.0125 .24721 1 0 Mshowa
p
.002 w
0 .37082 m
.00625 .37082 L
s
P
[(0.6)] -0.0125 .37082 1 0 Mshowa
p
.002 w
0 .49443 m
.00625 .49443 L
s
P
[(0.8)] -0.0125 .49443 1 0 Mshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(1)] -0.0125 .61803 1 0 Mshowa
p
.001 w
0 .02472 m
.00375 .02472 L
s
P
p
.001 w
0 .04944 m
.00375 .04944 L
s
P
p
.001 w
0 .07416 m
.00375 .07416 L
s
P
p
.001 w
0 .09889 m
.00375 .09889 L
s
P
p
.001 w
0 .14833 m
.00375 .14833 L
s
P
p
.001 w
0 .17305 m
.00375 .17305 L
s
P
p
.001 w
0 .19777 m
.00375 .19777 L
s
P
p
.001 w
0 .22249 m
.00375 .22249 L
s
P
p
.001 w
0 .27193 m
.00375 .27193 L
s
P
p
.001 w
0 .29666 m
.00375 .29666 L
s
P
p
.001 w
0 .32138 m
.00375 .32138 L
s
P
p
.001 w
0 .3461 m
.00375 .3461 L
s
P
p
.001 w
0 .39554 m
.00375 .39554 L
s
P
p
.001 w
0 .42026 m
.00375 .42026 L
s
P
p
.001 w
0 .44498 m
.00375 .44498 L
s
P
p
.001 w
0 .46971 m
.00375 .46971 L
s
P
p
.001 w
0 .51915 m
.00375 .51915 L
s
P
p
.001 w
0 .54387 m
.00375 .54387 L
s
P
p
.001 w
0 .56859 m
.00375 .56859 L
s
P
p
.001 w
0 .59331 m
.00375 .59331 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
0 0 m
.00033 0 L
.00065 0 L
.00098 0 L
.0013 1e-05 L
.00163 1e-05 L
.00195 1e-05 L
.0026 2e-05 L
.00326 3e-05 L
.00391 5e-05 L
.00521 8e-05 L
.00651 .00013 L
.00781 .00018 L
.01042 .00033 L
.01302 .00051 L
.01563 .00074 L
.02083 .00131 L
.02604 .00206 L
.03125 .00297 L
.04167 .00533 L
.05208 .00843 L
.0625 .01232 L
.07292 .01705 L
.08333 .02269 L
.09375 .02934 L
.10417 .03707 L
.11458 .046 L
.125 .05622 L
.13542 .06786 L
.14583 .08104 L
.15625 .09586 L
.16667 .11243 L
.17708 .13083 L
.1875 .15113 L
.19792 .17332 L
.20833 .19739 L
.21875 .22321 L
.22917 .25061 L
.23958 .27933 L
.24479 .29407 L
.2474 .30152 L
.2487 .30527 L
.24935 .30714 L
.24967 .30808 L
s
P
P
p
p
.004 w
.25098 .31184 m
.25195 .31466 L
.25391 .32032 L
.25781 .33167 L
.26563 .35445 L
.28125 .39949 L
.3125 .4817 L
.32813 .51611 L
.34375 .54497 L
.35938 .5681 L
.375 .5858 L
.38281 .5928 L
.39063 .59868 L
.39844 .60355 L
.40625 .60751 L
.41406 .61067 L
.42188 .61312 L
.42969 .61497 L
.43359 .6157 L
.4375 .61631 L
.44141 .61681 L
.44531 .61721 L
.44922 .61752 L
.45117 .61764 L
.45313 .61775 L
.45508 .61784 L
.45703 .61791 L
.45898 .61796 L
.45996 .61798 L
.46094 .618 L
.46191 .61801 L
.46289 .61802 L
.46387 .61803 L
.46484 .61803 L
.46582 .61803 L
.4668 .61803 L
.46777 .61803 L
.46875 .61802 L
.4707 .61799 L
.47266 .61796 L
.47656 .61786 L
.48047 .61773 L
.48438 .61757 L
.5 .61674 L
.53125 .61487 L
.54688 .6141 L
.55469 .61379 L
.5625 .61353 L
.57031 .61334 L
.57422 .61326 L
Mistroke
.57813 .6132 L
.58203 .61315 L
.58398 .61313 L
.58594 .61311 L
.58789 .6131 L
.58887 .6131 L
.58984 .61309 L
.59082 .61309 L
.5918 .61309 L
.59277 .61308 L
.59375 .61308 L
.59473 .61308 L
.5957 .61308 L
.59668 .61309 L
.59766 .61309 L
.59863 .61309 L
.59961 .6131 L
.60156 .61311 L
.60352 .61312 L
.60547 .61313 L
.60938 .61317 L
.61719 .61329 L
.625 .61344 L
.64063 .61384 L
.65625 .61433 L
.6875 .61543 L
.71875 .61648 L
.73438 .61692 L
.75 .6173 L
.76563 .61759 L
.77344 .61771 L
.78125 .61781 L
.78906 .61789 L
.79688 .61795 L
.80078 .61797 L
.80469 .61799 L
.80859 .61801 L
.81055 .61801 L
.8125 .61802 L
.81445 .61802 L
.81641 .61803 L
.81836 .61803 L
.81934 .61803 L
.82031 .61803 L
.82129 .61803 L
.82227 .61803 L
.82324 .61803 L
.82422 .61803 L
.8252 .61803 L
.82617 .61803 L
Mistroke
.82715 .61803 L
.82813 .61803 L
.83008 .61803 L
.83203 .61803 L
.83594 .61802 L
.83984 .61801 L
.84375 .618 L
.85938 .61793 L
.875 .61784 L
.90625 .61765 L
.92188 .61756 L
.9375 .61748 L
.94531 .61745 L
.95313 .61743 L
.95703 .61742 L
.96094 .61741 L
.96484 .6174 L
.96875 .61739 L
.9707 .61739 L
.97266 .61739 L
.97461 .61739 L
.97656 .61739 L
.97754 .61739 L
.97852 .61739 L
.97949 .61739 L
.98047 .61739 L
.98145 .61739 L
.98242 .61739 L
.9834 .61739 L
.98438 .61739 L
.98535 .61739 L
.98633 .61739 L
.9873 .61739 L
.98828 .61739 L
.99023 .61739 L
.99219 .61739 L
.99609 .61739 L
1 .6174 L
Mfstroke
P
P
P
% End of Graphics
MathPictureEnd

:[font = output; output; inactive; preserveAspect; endGroup]
Graphics["<<>>"]
;[o]
-Graphics-
^*)